/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.api.client.util.Strings;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.support.ResourceHelper;

public final class GoogleCloudStorageConnectionFactory {
    private GoogleCloudStorageConnectionFactory() {
    }

    public static Storage create(CamelContext context, GoogleCloudStorageConfiguration configuration) throws Exception {
        if (!Strings.isNullOrEmpty(configuration.getServiceAccountKey())) {
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream(context, configuration.getServiceAccountKey());
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials(ServiceAccountCredentials.fromStream(resolveMandatoryResourceAsInputStream))).build().getService();
            return storage;
        }
        Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
        return storage;
    }
}

