/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.PickFirstBalancerFactory;
import io.grpc.Status;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.ServiceConfigUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoConfiguredLoadBalancerFactory
extends LoadBalancer.Factory {
    @VisibleForTesting
    static final String ROUND_ROBIN_LOAD_BALANCER_FACTORY_NAME = "io.grpc.util.RoundRobinLoadBalancerFactory";
    @VisibleForTesting
    static final String GRPCLB_LOAD_BALANCER_FACTORY_NAME = "io.grpc.grpclb.GrpclbLoadBalancerFactory";

    AutoConfiguredLoadBalancerFactory() {
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper);
    }

    private static final class FailingPicker
    extends LoadBalancer.SubchannelPicker {
        private final Status failure;

        FailingPicker(Status failure) {
            this.failure = failure;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withError(this.failure);
        }
    }

    private static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        private EmptyPicker() {
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    @VisibleForTesting
    static final class AutoConfiguredLoadBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancer.Factory delegateFactory;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = helper;
            this.delegateFactory = PickFirstBalancerFactory.getInstance();
            this.delegate = this.delegateFactory.newLoadBalancer(helper);
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
            LoadBalancer.Factory newlbf;
            Map<String, Object> configMap = attributes.get(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG);
            try {
                newlbf = AutoConfiguredLoadBalancer.decideLoadBalancerFactory(servers, configMap);
            }
            catch (RuntimeException e) {
                Status s2 = Status.INTERNAL.withDescription("Failed to pick a load balancer from service config").withCause(e);
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new FailingPicker(s2));
                this.delegate.shutdown();
                this.delegateFactory = null;
                this.delegate = new NoopLoadBalancer();
                return;
            }
            if (newlbf != null && newlbf != this.delegateFactory) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
                this.delegate.shutdown();
                this.delegateFactory = newlbf;
                this.delegate = this.delegateFactory.newLoadBalancer(this.helper);
            }
            this.getDelegate().handleResolvedAddressGroups(servers, attributes);
        }

        @Override
        public void handleNameResolutionError(Status error) {
            this.getDelegate().handleNameResolutionError(error);
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.getDelegate().handleSubchannelState(subchannel, stateInfo);
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        @VisibleForTesting
        LoadBalancer getDelegate() {
            return this.delegate;
        }

        @VisibleForTesting
        void setDelegate(LoadBalancer lb) {
            this.delegate = lb;
        }

        @VisibleForTesting
        LoadBalancer.Factory getDelegateFactory() {
            return this.delegateFactory;
        }

        @Nullable
        @VisibleForTesting
        static LoadBalancer.Factory decideLoadBalancerFactory(List<EquivalentAddressGroup> servers, @Nullable Map<String, Object> config) {
            boolean haveBalancerAddress = false;
            for (EquivalentAddressGroup s2 : servers) {
                if (s2.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) == null) continue;
                haveBalancerAddress = true;
                break;
            }
            if (haveBalancerAddress) {
                try {
                    Class<?> lbFactoryClass = Class.forName(AutoConfiguredLoadBalancerFactory.GRPCLB_LOAD_BALANCER_FACTORY_NAME);
                    Method getInstance = lbFactoryClass.getMethod("getInstance", new Class[0]);
                    return (LoadBalancer.Factory)getInstance.invoke(null, new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't get GRPCLB, but balancer addresses were present", e);
                }
            }
            String serviceConfigChoiceBalancingPolicy = null;
            if (config != null) {
                serviceConfigChoiceBalancingPolicy = ServiceConfigUtil.getLoadBalancingPolicyFromServiceConfig(config);
            }
            if (serviceConfigChoiceBalancingPolicy != null) {
                if (serviceConfigChoiceBalancingPolicy.toUpperCase(Locale.ROOT).equals("ROUND_ROBIN")) {
                    try {
                        Class<?> lbFactoryClass = Class.forName(AutoConfiguredLoadBalancerFactory.ROUND_ROBIN_LOAD_BALANCER_FACTORY_NAME);
                        Method getInstance = lbFactoryClass.getMethod("getInstance", new Class[0]);
                        return (LoadBalancer.Factory)getInstance.invoke(null, new Object[0]);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Can't get Round Robin LB", e);
                    }
                }
                throw new IllegalArgumentException("Unknown service config policy: " + serviceConfigChoiceBalancingPolicy);
            }
            return PickFirstBalancerFactory.getInstance();
        }
    }

    private static final class NoopLoadBalancer
    extends LoadBalancer {
        private NoopLoadBalancer() {
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> s2, Attributes a) {
        }

        @Override
        public void handleNameResolutionError(Status error) {
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        }

        @Override
        public void shutdown() {
        }
    }
}

