/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.guice.support.internal.MethodKey;

public final class Reflectors {
    private Reflectors() {
    }

    public static List<Method> getAllMethods(Class<?> type) {
        return Reflectors.getAllMethods(TypeLiteral.get(type));
    }

    public static List<Method> getAllMethods(TypeLiteral<?> startType) {
        Class<?> type;
        ArrayList<Method> answer = Lists.newArrayList();
        HashMap<MethodKey, Method> boundMethods = Maps.newHashMap();
        while ((type = startType.getRawType()) != Object.class) {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                MethodKey key = new MethodKey(method);
                if (boundMethods.get(key) != null) continue;
                boundMethods.put(key, method);
                answer.add(method);
            }
            Class<?> supertype = type.getSuperclass();
            if (supertype == Object.class) break;
            startType = startType.getSupertype(supertype);
        }
        return answer;
    }
}

