/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.support.internal;

import com.google.inject.internal.Errors;
import com.google.inject.spi.Message;
import org.apache.camel.guice.support.CloseErrors;
import org.apache.camel.guice.support.CloseFailedException;

public class CloseErrorsImpl
implements CloseErrors {
    final Errors errors;

    public CloseErrorsImpl(Object source) {
        this.errors = new Errors(source);
    }

    @Override
    public void closeError(Object key, Object object, Exception cause) {
        String message = Errors.format("Failed to close object %s with key %s", object, key);
        this.errors.addMessage(new Message(this.errors.getSources(), message, cause));
    }

    @Override
    public void throwIfNecessary() throws CloseFailedException {
        if (!this.errors.hasErrors()) {
            return;
        }
        throw new CloseFailedException(this.errors.getMessages());
    }
}

