/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.io;

import java.io.File;
import java.io.IOException;
import org.fusesource.hawtdb.internal.io.MemoryMappedFile;

public class MemoryMappedFileFactory {
    private MemoryMappedFile memoryMappedFile;
    private File file;
    private int mappingSegementSize = 0x4000000;
    private boolean readOnly = false;

    public void open() throws IOException {
        if (this.memoryMappedFile == null) {
            if (this.file == null) {
                throw new IllegalArgumentException("file property not set");
            }
            if (this.mappingSegementSize <= 0) {
                throw new IllegalArgumentException("mappingSegementSize property must be greater than 0");
            }
            this.file.getCanonicalFile().getParentFile().mkdirs();
            this.memoryMappedFile = new MemoryMappedFile(this.file, this.mappingSegementSize, this.readOnly);
        }
    }

    public void close() {
        if (this.memoryMappedFile != null) {
            this.memoryMappedFile.close();
            this.memoryMappedFile = null;
        }
    }

    public MemoryMappedFile getMemoryMappedFile() throws IOException {
        return this.memoryMappedFile;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getMappingSegementSize() {
        return this.mappingSegementSize;
    }

    public void setMappingSegementSize(int mappingSegementSize) {
        this.mappingSegementSize = mappingSegementSize;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

