/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.fusesource.hawtdb.api.Allocator;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.internal.page.Commit;
import org.fusesource.hawtdb.internal.page.DeferredUpdate;
import org.fusesource.hawtdb.internal.page.Logging;
import org.fusesource.hawtdb.internal.page.Update;
import org.fusesource.hawtdb.util.list.LinkedNode;
import org.fusesource.hawtdb.util.list.LinkedNodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Batch
extends LinkedNode<Batch>
implements Externalizable,
Iterable<Commit> {
    private static final long serialVersionUID = 1188640492489990493L;
    volatile int page = -1;
    public volatile int previous = -1;
    volatile boolean recovered;
    final LinkedNodeList<Commit> commits = new LinkedNodeList();
    volatile int snapshots;
    public volatile long base = -1L;
    public volatile long head;
    volatile boolean performed;
    volatile ArrayList<Runnable> flushCallbacks = new ArrayList();

    public Batch() {
    }

    public boolean isPerformed() {
        return this.performed;
    }

    public Batch(long head) {
        this.head = head;
    }

    public String toString() {
        return "{ page: " + this.page + ", base: " + this.base + ", head: " + this.head + ", snapshots: " + this.snapshots + ", commits: " + this.commits.size() + ", previous: " + this.previous + " }";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.head);
        out.writeLong(this.base);
        out.writeInt(this.previous);
        ArrayList<Commit> l = new ArrayList<Commit>();
        for (Commit commit : this) {
            l.add(commit);
        }
        out.writeObject(l);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.head = in.readLong();
        this.base = in.readLong();
        this.previous = in.readInt();
        ArrayList l = (ArrayList)in.readObject();
        for (Commit commit : l) {
            this.commits.addLast(commit);
        }
    }

    public int pageCount() {
        int rc = 0;
        for (Commit commit : this) {
            rc += commit.updates.size();
        }
        return rc;
    }

    public Commit getHeadCommit() {
        for (Batch b = this; b != null; b = (Batch)b.getPrevious()) {
            if (b.commits.isEmpty()) continue;
            return b.commits.getTail();
        }
        return null;
    }

    @Override
    public Iterator<Commit> iterator() {
        return new Iterator<Commit>(){
            Commit next;
            Commit last;
            {
                this.next = Batch.this.commits.getHead();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Commit next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.next = (Commit)this.next.getNext();
                return this.last;
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        };
    }

    public void performDeferredUpdates(Paged pageFile) {
        for (Commit commit : this) {
            assert (commit.stillSane());
            if (commit.updates == null) continue;
            for (Map.Entry<Integer, Update> entry : commit.updates.entrySet()) {
                List<Integer> freePages;
                Integer page = entry.getKey();
                DeferredUpdate du = entry.getValue().deferredUpdate();
                if (du == null) continue;
                assert (!du.shadowed()) : "deferred update should not have a shadow page.";
                if (du.removed()) {
                    assert (!du.put());
                    freePages = du.marshaller.pagesLinked(pageFile, page);
                    for (Integer linkedPage : freePages) {
                        commit.merge(pageFile.allocator(), linkedPage, Update.update().freed(true));
                    }
                }
                if (!du.put()) continue;
                assert (!du.removed());
                if (!du.allocated()) {
                    du.shadow(pageFile.allocator().alloc(1));
                    freePages = du.marshaller.pagesLinked(pageFile, page);
                    for (Integer linkedPage : freePages) {
                        commit.merge(pageFile.allocator(), linkedPage, Update.update().freed(true));
                    }
                }
                List<Integer> linkedPages = du.marshaller.store(pageFile, du.translate(page), du.value);
                if (Logging.traced(page)) {
                    Logging.trace("storing update of %d at %d linked pages: %s", page, du.translate(page), linkedPages);
                }
                for (Integer linkedPage : linkedPages) {
                    commit.merge(pageFile.allocator(), linkedPage, Update.update().allocated(true));
                }
            }
        }
    }

    public void release(Allocator allocator) {
        for (Commit commit : this) {
            for (Map.Entry<Integer, Update> entry : commit.updates.entrySet()) {
                int key = entry.getKey();
                Update value = entry.getValue();
                if (value.freed()) {
                    assert (!value.shadowed());
                    allocator.free(key, 1);
                }
                if (!value.shadowed()) continue;
                assert (!value.freed());
                allocator.free(value.shadow(), 1);
            }
        }
    }
}

