/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.PageFile;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.PagedAccessor;
import org.fusesource.hawtdb.internal.io.MemoryMappedFile;
import org.fusesource.hawtdb.internal.page.ExtentOutputStream;
import org.fusesource.hawtdb.internal.page.Logging;
import org.fusesource.hawtdb.internal.page.SimpleAllocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HawtPageFile
implements PageFile {
    private final SimpleAllocator allocator;
    private final short pageSize;
    private final int headerSize;
    private final MemoryMappedFile file;
    public final boolean storeFreePages;

    public HawtPageFile(MemoryMappedFile file, short pageSize, int headerSize, int maxPages, boolean storeFreePages) throws IOException {
        this.file = file;
        this.allocator = new SimpleAllocator(maxPages);
        this.pageSize = pageSize;
        this.headerSize = headerSize;
        this.storeFreePages = storeFreePages;
    }

    public void close() throws IOException {
        if (this.storeFreePages) {
            DataOutputStream os = new DataOutputStream(new ExtentOutputStream(this, this.alloc(), 1, 1));
            os.writeBoolean(true);
            os.close();
        }
    }

    @Override
    public SimpleAllocator allocator() {
        return this.allocator;
    }

    @Override
    public int alloc() {
        return this.allocator().alloc(1);
    }

    @Override
    public void free(int page) {
        this.allocator().free(page, 1);
    }

    @Override
    public void read(int pageId, Buffer buffer) {
        if (Logging.traced(pageId)) {
            Logging.trace("read: %d", pageId);
        }
        this.file.read(this.offset(pageId), buffer);
    }

    @Override
    public void write(int pageId, Buffer buffer) {
        if (Logging.traced(pageId)) {
            Logging.trace("write: %d", pageId);
        }
        this.file.write(this.offset(pageId), buffer);
    }

    @Override
    public ByteBuffer slice(Paged.SliceType type, int pageId, int size) {
        if (Logging.traced(pageId)) {
            Logging.trace("slice: %d, type %s", new Object[]{pageId, type});
        }
        assert (size > 0);
        return this.file.slice(type == Paged.SliceType.READ, this.offset(pageId), this.pageSize * size);
    }

    @Override
    public void unslice(ByteBuffer buffer) {
        this.file.unslice(buffer);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int pages(int length) {
        assert (length >= 0);
        return (length - 1) / this.pageSize + 1;
    }

    @Override
    public void flush() {
        this.file.sync();
    }

    @Override
    public <T> T get(PagedAccessor<T> pagedAccessor, int page) {
        return pagedAccessor.load(this, page);
    }

    @Override
    public <T> void put(PagedAccessor<T> pagedAccessor, int page, T value) {
        pagedAccessor.store(this, page, value);
    }

    @Override
    public <T> void clear(PagedAccessor<T> pagedAccessor, int page) {
        pagedAccessor.pagesLinked(this, page);
    }

    @Override
    public void write(int pageId, ByteBuffer buffer) {
        if (Logging.traced(pageId)) {
            Logging.trace("write to: %d", pageId);
        }
        this.file.write(this.offset(pageId), buffer);
    }

    public long offset(long pageId) {
        assert (pageId >= 0L);
        return (long)this.headerSize + pageId * (long)this.pageSize;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public MemoryMappedFile getFile() {
        return this.file;
    }

    public String toString() {
        return "{ header size: " + this.headerSize + ", page size: " + this.pageSize + ", allocator: " + this.allocator + " }";
    }
}

