/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 6107175734705142096L;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private int count;
    private TreeEntry<K, V> root;
    private final Comparator<? super K> comparator;

    public TreeMap() {
        this.comparator = null;
    }

    private int compare(K k1, K k2) {
        if (this.comparator != null) {
            return this.comparator.compare(k1, k2);
        }
        return ((Comparable)k1).compareTo(k2);
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    public K firstKey() {
        TreeEntry<K, V> first = this.firstEntry();
        if (first != null) {
            return first.key;
        }
        return null;
    }

    public K lastKey() {
        TreeEntry<K, V> last = this.lastEntry();
        if (last != null) {
            return last.key;
        }
        return null;
    }

    public void clear() {
        this.root = null;
        this.count = 0;
    }

    public boolean containsKey(K key) {
        return this.getEntry(key, this.root) != null;
    }

    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (entry.getValue() == value) {
                return true;
            }
            if (value == null || !value.equals(entry)) continue;
            return true;
        }
        return false;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean contains(Object o) {
                try {
                    Map.Entry entry = (Map.Entry)o;
                    TreeEntry ours = TreeMap.this.getEntry(entry.getKey(), TreeMap.this.root);
                    if (ours != null) {
                        return ours.value == null ? entry.getValue() == null : ours.value.equals(entry.getValue());
                    }
                    return false;
                }
                catch (ClassCastException cce) {
                    return false;
                }
            }

            @Override
            public boolean remove(Object o) {
                return TreeMap.this.removeEntry((TreeEntry)o) != null;
            }

            @Override
            public int size() {
                return TreeMap.this.count;
            }

            @Override
            public void clear() {
                TreeMap.this.clear();
            }
        };
    }

    public V get(K key) {
        TreeEntry<K, V> node = this.getEntry(key, this.root);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    public final TreeEntry<K, V> getEntry(K key) {
        return this.getEntry(key, this.root);
    }

    private final TreeEntry<K, V> getEntry(K key, TreeEntry<K, V> r) {
        while (r != null) {
            int c = this.compare(key, r.key);
            if (c == 0) {
                return r;
            }
            if (c > 0) {
                r = r.right;
                continue;
            }
            r = r.left;
        }
        return null;
    }

    public TreeEntry<K, V> firstEntry() {
        TreeEntry<K, V> r = this.root;
        while (r != null && r.left != null) {
            r = r.left;
        }
        return r;
    }

    public TreeEntry<K, V> lastEntry() {
        TreeEntry<K, V> r = this.root;
        while (r != null && r.right != null) {
            r = r.right;
        }
        return r;
    }

    public TreeEntry<K, V> lowerEntry(K key) {
        TreeEntry<K, V> n = this.root;
        TreeEntry<K, V> l = null;
        while (n != null) {
            int c = this.compare(key, n.key);
            if (c <= 0) {
                n = n.left;
                continue;
            }
            if (l == null || this.compare(n.key, l.key) > 0) {
                l = n;
            }
            if (n.right == null) break;
            n = n.right;
        }
        return l;
    }

    public TreeEntry<K, V> floorEntry(K key) {
        TreeEntry<K, V> n = this.root;
        TreeEntry<K, V> l = null;
        while (n != null) {
            int c = this.compare(key, n.key);
            if (c == 0) {
                return n;
            }
            if (c < 0) {
                n = n.left;
                continue;
            }
            if (l == null || this.compare(n.key, l.key) > 0) {
                l = n;
            }
            if (n.right == null) break;
            n = n.right;
        }
        return l;
    }

    public TreeEntry<K, V> upperEntry(K key) {
        TreeEntry<K, V> n = this.root;
        TreeEntry<K, V> h = null;
        while (n != null) {
            int c = this.compare(key, n.key);
            if (c >= 0) {
                n = n.right;
                continue;
            }
            if (h == null || this.compare(n.key, h.key) < 0) {
                h = n;
            }
            if (n.left == null) break;
            n = n.left;
        }
        return h;
    }

    public TreeEntry<K, V> ceilingEntry(K key) {
        TreeEntry<K, V> n = this.root;
        TreeEntry<K, V> h = null;
        while (n != null) {
            int c = this.compare(key, n.key);
            if (c == 0) {
                return n;
            }
            if (c > 0) {
                n = n.right;
                continue;
            }
            if (h == null || this.compare(n.key, h.key) < 0) {
                h = n;
            }
            if (n.left == null) break;
            n = n.left;
        }
        return h;
    }

    private static final <K, V> TreeEntry<K, V> next(TreeEntry<K, V> n) {
        if (n == null) {
            return null;
        }
        if (n.right != null) {
            TreeEntry p = n.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        TreeEntry p = n.parent;
        TreeEntry<K, V> ch = n;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static final <K, V> TreeEntry<K, V> previous(TreeEntry<K, V> n) {
        if (n == null) {
            return null;
        }
        if (n.left != null) {
            TreeEntry p = n.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        TreeEntry p = n.parent;
        TreeEntry<K, V> ch = n;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public void clear() {
                TreeMap.this.clear();
            }

            @Override
            public boolean remove(Object o) {
                return TreeMap.this.remove(o) != null;
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return TreeMap.this.count;
            }
        };
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(K key) {
        return this.removeEntry(this.getEntry(key, this.root));
    }

    public V put(K key, V value) {
        if (this.root == null) {
            this.root = new TreeEntry<K, V>(key, value, null, this);
            ++this.count;
            return null;
        }
        TreeEntry<K, V> n = this.root;
        while (true) {
            int c;
            if ((c = this.compare(key, n.key)) == 0) {
                Object old = n.value;
                n.value = value;
                return old;
            }
            if (c < 0) {
                if (n.left != null) {
                    n = n.left;
                    continue;
                }
                n.left = new TreeEntry<K, V>(key, value, n, this);
                ++this.count;
                this.doRedBlackInsert(n.left);
                return null;
            }
            if (n.right == null) break;
            n = n.right;
        }
        n.right = new TreeEntry<K, V>(key, value, n, this);
        ++this.count;
        this.doRedBlackInsert(n.right);
        return null;
    }

    private void doRedBlackInsert(TreeEntry<K, V> n) {
        TreeEntry<K, V> currentNode = n;
        TreeMap.color(currentNode, false);
        while (currentNode != null && currentNode != this.root && TreeMap.isRed(currentNode.parent)) {
            TreeEntry<K, V> y;
            if (TreeMap.isLeftChild(TreeMap.parent(currentNode))) {
                y = TreeMap.getRight(TreeMap.getGrandParent(currentNode));
                if (TreeMap.isRed(y)) {
                    TreeMap.color(TreeMap.parent(currentNode), true);
                    TreeMap.color(y, true);
                    TreeMap.color(TreeMap.getGrandParent(currentNode), false);
                    currentNode = TreeMap.getGrandParent(currentNode);
                    continue;
                }
                if (TreeMap.isRightChild(currentNode)) {
                    currentNode = TreeMap.parent(currentNode);
                    this.rotateLeft(currentNode);
                }
                TreeMap.color(TreeMap.parent(currentNode), true);
                TreeMap.color(TreeMap.getGrandParent(currentNode), false);
                if (TreeMap.getGrandParent(currentNode) == null) continue;
                this.rotateRight(TreeMap.getGrandParent(currentNode));
                continue;
            }
            y = TreeMap.getLeft(TreeMap.getGrandParent(currentNode));
            if (TreeMap.isRed(y)) {
                TreeMap.color(TreeMap.parent(currentNode), true);
                TreeMap.color(y, true);
                TreeMap.color(TreeMap.getGrandParent(currentNode), false);
                currentNode = TreeMap.getGrandParent(currentNode);
                continue;
            }
            if (TreeMap.isLeftChild(currentNode)) {
                currentNode = TreeMap.parent(currentNode);
                this.rotateRight(currentNode);
            }
            TreeMap.color(TreeMap.parent(currentNode), true);
            TreeMap.color(TreeMap.getGrandParent(currentNode), false);
            if (TreeMap.getGrandParent(currentNode) == null) continue;
            this.rotateLeft(TreeMap.getGrandParent(currentNode));
        }
        TreeMap.color(this.root, true);
    }

    private void rotateLeft(TreeEntry<K, V> n) {
        TreeEntry r = n.right;
        n.right = r.left;
        if (r.left != null) {
            r.left.parent = n;
        }
        r.parent = n.parent;
        if (n.parent == null) {
            this.root = r;
        } else if (n.parent.left == n) {
            n.parent.left = r;
        } else {
            n.parent.right = r;
        }
        r.left = n;
        n.parent = r;
    }

    private void rotateRight(TreeEntry<K, V> n) {
        TreeEntry l = n.left;
        n.left = l.right;
        if (l.right != null) {
            l.right.parent = n;
        }
        l.parent = n.parent;
        if (n.parent == null) {
            this.root = l;
        } else if (n.parent.right == n) {
            n.parent.right = l;
        } else {
            n.parent.left = l;
        }
        l.right = n;
        n.parent = l;
    }

    public final V removeEntry(TreeEntry<K, V> n) {
        TreeEntry replacement;
        if (n == null) {
            return null;
        }
        if (n.map != this) {
            throw new IllegalStateException("Node not in list");
        }
        Object old = n.value;
        --this.count;
        if (n.left != null && n.right != null) {
            TreeEntry<K, V> next = TreeMap.next(n);
            n.key = next.key;
            n.value = next.value;
            n = next;
        }
        TreeEntry treeEntry = replacement = n.left != null ? n.left : n.right;
        if (replacement != null) {
            replacement.parent = n.parent;
            if (n.parent == null) {
                this.root = replacement;
            } else if (n == n.parent.left) {
                n.parent.left = replacement;
            } else {
                n.parent.right = replacement;
            }
            n.left = null;
            n.right = null;
            n.parent = null;
            if (TreeMap.isBlack(n)) {
                this.doRedBlackDeleteFixup(replacement);
            }
        } else if (n.parent == null) {
            this.root = null;
        } else {
            if (TreeMap.isBlack(n)) {
                this.doRedBlackDeleteFixup(n);
            }
            if (n.parent != null) {
                if (n == n.parent.left) {
                    n.parent.left = null;
                } else {
                    n.parent.right = null;
                }
                n.parent = null;
            }
        }
        return old;
    }

    private void doRedBlackDeleteFixup(TreeEntry<K, V> replacementNode) {
        TreeEntry<K, V> currentNode = replacementNode;
        while (currentNode != this.root && TreeMap.isBlack(currentNode)) {
            TreeEntry<K, V> siblingNode;
            if (TreeMap.isLeftChild(currentNode)) {
                siblingNode = TreeMap.getRight(TreeMap.parent(currentNode));
                if (TreeMap.isRed(siblingNode)) {
                    TreeMap.color(siblingNode, true);
                    TreeMap.color(TreeMap.parent(currentNode), false);
                    this.rotateLeft(TreeMap.parent(currentNode));
                    siblingNode = TreeMap.getRight(TreeMap.parent(currentNode));
                }
                if (TreeMap.isBlack(TreeMap.getLeft(siblingNode)) && TreeMap.isBlack(TreeMap.getRight(siblingNode))) {
                    TreeMap.color(siblingNode, false);
                    currentNode = TreeMap.parent(currentNode);
                    continue;
                }
                if (TreeMap.isBlack(TreeMap.getRight(siblingNode))) {
                    TreeMap.color(TreeMap.getLeft(siblingNode), true);
                    TreeMap.color(siblingNode, false);
                    this.rotateRight(siblingNode);
                    siblingNode = TreeMap.getRight(TreeMap.parent(currentNode));
                }
                TreeMap.color(siblingNode, TreeMap.getColor(TreeMap.parent(currentNode)));
                TreeMap.color(TreeMap.parent(currentNode), true);
                TreeMap.color(TreeMap.getRight(siblingNode), true);
                this.rotateLeft(TreeMap.parent(currentNode));
                currentNode = this.root;
                continue;
            }
            siblingNode = TreeMap.getLeft(TreeMap.parent(currentNode));
            if (TreeMap.isRed(siblingNode)) {
                TreeMap.color(siblingNode, true);
                TreeMap.color(TreeMap.parent(currentNode), false);
                this.rotateRight(TreeMap.parent(currentNode));
                siblingNode = TreeMap.getLeft(TreeMap.parent(currentNode));
            }
            if (TreeMap.isBlack(TreeMap.getRight(siblingNode)) && TreeMap.isBlack(TreeMap.getLeft(siblingNode))) {
                TreeMap.color(siblingNode, false);
                currentNode = TreeMap.parent(currentNode);
                continue;
            }
            if (TreeMap.isBlack(TreeMap.getLeft(siblingNode))) {
                TreeMap.color(TreeMap.getRight(siblingNode), true);
                TreeMap.color(siblingNode, false);
                this.rotateLeft(siblingNode);
                siblingNode = TreeMap.getLeft(TreeMap.parent(currentNode));
            }
            TreeMap.color(siblingNode, TreeMap.getColor(TreeMap.parent(currentNode)));
            TreeMap.color(TreeMap.parent(currentNode), true);
            TreeMap.color(TreeMap.getLeft(siblingNode), true);
            this.rotateRight(TreeMap.parent(currentNode));
            currentNode = this.root;
        }
        TreeMap.color(currentNode, true);
    }

    public int size() {
        return this.count;
    }

    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return TreeMap.this.count;
            }
        };
    }

    private static <K, V> TreeEntry<K, V> parent(TreeEntry<K, V> n) {
        return n == null ? null : n.parent;
    }

    private static <K, V> void color(TreeEntry<K, V> n, boolean c) {
        if (n != null) {
            n.color = c;
        }
    }

    private static <K, V> boolean getColor(TreeEntry<K, V> n) {
        return n == null ? true : n.color;
    }

    private static <K, V> TreeEntry<K, V> getLeft(TreeEntry<K, V> n) {
        return n == null ? null : n.left;
    }

    private static <K, V> TreeEntry<K, V> getRight(TreeEntry<K, V> n) {
        return n == null ? null : n.right;
    }

    private static <K, V> boolean isRed(TreeEntry<K, V> n) {
        return n == null ? false : !n.color;
    }

    private static <K, V> boolean isBlack(TreeEntry<K, V> n) {
        return n == null ? true : n.color;
    }

    private static <K, V> boolean isLeftChild(TreeEntry<K, V> node) {
        return node == null ? true : (node.parent == null ? false : node == node.parent.left);
    }

    private static <K, V> boolean isRightChild(TreeEntry<K, V> node) {
        return node == null ? true : (node.parent == null ? false : node == node.parent.right);
    }

    private static <K, V> TreeEntry<K, V> getGrandParent(TreeEntry<K, V> node) {
        return TreeMap.parent(TreeMap.parent(node));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractEntryIterator<T>
    implements Iterator<T> {
        TreeEntry<K, V> last = null;
        TreeEntry<K, V> next = TreeMap.this.firstEntry();

        private AbstractEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        protected TreeEntry<K, V> getNext() {
            this.last = this.next;
            this.next = TreeMap.next(this.next);
            return this.last;
        }

        @Override
        public void remove() {
            TreeMap.this.removeEntry(this.last);
            this.last = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends AbstractEntryIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.getNext();
            if (this.last == null) {
                return null;
            }
            return this.last;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends AbstractEntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            this.getNext();
            if (this.last == null) {
                return null;
            }
            return this.last.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends AbstractEntryIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            this.getNext();
            if (this.last == null) {
                return null;
            }
            return this.last.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 8490652911043012737L;
        volatile TreeMap<K, V> map;
        volatile V value;
        volatile K key;
        volatile boolean color = true;
        TreeEntry<K, V> parent;
        TreeEntry<K, V> left;
        TreeEntry<K, V> right;

        TreeEntry(K key, V val, TreeEntry<K, V> parent, TreeMap<K, V> map) {
            this.key = key;
            this.parent = parent;
            this.value = val;
            this.map = map;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V val) {
            V old = this.value;
            this.value = val;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public TreeEntry<K, V> next() {
            return TreeMap.next(this);
        }

        public TreeEntry<K, V> previous() {
            return TreeMap.previous(this);
        }

        public String toString() {
            return "{ key: " + this.key + ", value: " + this.value + " }";
        }
    }
}

