/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.api;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.fusesource.hawtdb.api.IndexException;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.PagedAccessor;
import org.fusesource.hawtdb.internal.page.Extent;
import org.fusesource.hawtdb.internal.page.ExtentInputStream;
import org.fusesource.hawtdb.internal.page.ExtentOutputStream;
import org.fusesource.hawtdb.internal.util.Ranges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStreamPagedAccessor<T>
implements PagedAccessor<T> {
    @Override
    public List<Integer> store(Paged paged, int page, T data) {
        ExtentOutputStream eos = new ExtentOutputStream(paged, page, 1, 128);
        DataOutputStream os = new DataOutputStream(eos);
        try {
            this.encode(paged, os, data);
            os.close();
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
        Ranges pages = eos.getPages();
        pages.remove(page);
        if (pages.isEmpty()) {
            return Collections.emptyList();
        }
        return pages.values();
    }

    @Override
    public T load(Paged paged, int page) {
        T t;
        ExtentInputStream eis = new ExtentInputStream(paged, page);
        DataInputStream is = new DataInputStream(eis);
        try {
            t = this.decode(paged, is);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable ignore) {}
        }
        return t;
    }

    @Override
    public List<Integer> pagesLinked(Paged paged, int page) {
        return Extent.pagesLinked(paged, page);
    }

    protected abstract void encode(Paged var1, DataOutputStream var2, T var3) throws IOException;

    protected abstract T decode(Paged var1, DataInputStream var2) throws IOException;
}

