/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fusesource.hawtdb.api.Allocator;
import org.fusesource.hawtdb.api.OptimisticUpdateException;
import org.fusesource.hawtdb.internal.page.Logging;
import org.fusesource.hawtdb.internal.page.SnapshotTracker;
import org.fusesource.hawtdb.internal.page.Update;
import org.fusesource.hawtdb.util.list.LinkedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Commit
extends LinkedNode<Commit>
implements Externalizable {
    volatile SnapshotTracker snapshotTracker;
    private volatile long base;
    private volatile long head;
    volatile ConcurrentHashMap<Integer, Update> updates;

    public Commit() {
    }

    public Commit(long version, ConcurrentHashMap<Integer, Update> updates) {
        this.head = this.base = version;
        this.updates = updates;
    }

    public long getHeadRevision() {
        return this.head;
    }

    public String toString() {
        int updateSize = this.updates == null ? 0 : this.updates.size();
        return "{ base: " + this.base + ", head: " + this.head + ", updates: " + updateSize + " }";
    }

    public long commitCheck(Map<Integer, Update> newUpdate) {
        for (Integer page : newUpdate.keySet()) {
            if (!this.updates.containsKey(page)) continue;
            throw new OptimisticUpdateException();
        }
        return this.head;
    }

    public void merge(Allocator allocator, long rev, ConcurrentHashMap<Integer, Update> updates) {
        assert (this.head + 1L == rev);
        this.head = rev;
        for (Map.Entry<Integer, Update> entry : updates.entrySet()) {
            this.merge(allocator, entry.getKey(), entry.getValue());
            if (!Logging.traced(entry.getKey())) continue;
            Logging.trace("merged: %s", entry);
        }
        assert (this.stillSane());
    }

    void merge(Allocator allocator, int page, Update update) {
        assert (!(update.allocated() && update.shadowed() && update.freed())) : "This update can't be in multiple states";
        Update previous = this.updates.put(page, update);
        if (previous != null) {
            previous.history.addAll(update.history);
            update.history = previous.history;
            if (update.freed()) {
                assert (!previous.freed()) : "free can not follow a free.";
                if (previous.shadowed()) {
                    update.note("free previous shadow: " + previous.shadow());
                    allocator.free(previous.shadow(), 1);
                }
                if (previous.allocated()) {
                    allocator.free(page, 1);
                    this.updates.remove(page);
                }
            } else if (update.allocated()) {
                if (!previous.freed()) assert (previous.freed()) : "allocation updates can only follow freed updates.";
                assert (!previous.allocated() || !previous.shadowed()) : "Unexpected previous state.";
                if (!update.put()) {
                    this.updates.remove(page);
                }
            } else if (update.shadowed()) {
                if (previous.allocated()) {
                    update.allocated(true);
                }
                if (previous.shadowed()) {
                    update.note("free previous shadow: " + previous.shadow());
                    allocator.free(previous.shadow(), 1);
                }
            } else if (update.deferredUpdate() != null) {
                assert (!previous.shadowed()) : "deferred updates should not have shadows assigned.";
                if (previous.allocated()) {
                    update.allocated(true);
                }
            } else {
                throw new AssertionError((Object)"Unexpected update state");
            }
        }
    }

    public boolean stillSane() {
        for (Map.Entry<Integer, Update> entry : this.updates.entrySet()) {
            Update badboy;
            int page = entry.getKey();
            Update update = entry.getValue();
            if (update.shadowed() && (badboy = this.updates.get(update.shadow())) != null) {
                throw new AssertionError((Object)("a normal page (" + page + ") is also being used as a shadow page (" + update.shadow() + ")."));
            }
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.base = in.readLong();
        this.head = in.readLong();
        this.updates = (ConcurrentHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.base);
        out.writeLong(this.head);
        out.writeObject(this.updates);
    }
}

