/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.internal.page.Extent;
import org.fusesource.hawtdb.internal.util.Ranges;

public class ExtentInputStream
extends InputStream {
    private final Paged paged;
    private Extent current;
    private final int page;
    private Ranges pages = new Ranges();

    public ExtentInputStream(Paged paged, int page) {
        this.paged = paged;
        this.page = page;
        this.current = new Extent(paged, page);
        this.current.readOpen();
        this.pages.add(this.current.getPage(), paged.pages(this.current.getLength()));
    }

    public String toString() {
        return "{ page: " + this.page + ", current: " + this.current + " }";
    }

    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        if (this.current.atEnd()) {
            int next = this.current.getNext();
            if (next == -1) {
                this.current.readClose();
                this.current = null;
                return -1;
            }
            this.current.readClose();
            this.current = new Extent(this.paged, next);
            this.current.readOpen();
            this.pages.add(this.current.getPage(), this.paged.pages(this.current.getLength()));
        }
        return this.current.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rc = len;
        Buffer buffer = new Buffer(b, off, len);
        if (this.current == null) {
            throw new EOFException();
        }
        while (buffer.length > 0) {
            if (this.current.atEnd()) {
                int next = this.current.getNext();
                if (next == -1) {
                    this.current.readClose();
                    this.current = null;
                    break;
                }
                this.current.readClose();
                this.current = new Extent(this.paged, next);
                this.current.readOpen();
                this.pages.add(this.current.getPage(), this.paged.pages(this.current.getLength()));
            }
            this.current.read(buffer);
        }
        if ((rc -= buffer.length) == 0) {
            throw new EOFException();
        }
        return rc;
    }

    public void close() throws IOException {
        if (this.current != null) {
            this.current.readClose();
            this.current = null;
        }
    }

    public Ranges getPages() {
        return this.pages;
    }
}

