/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.index;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.fusesource.hawtdb.internal.index.BTreeIndex;
import org.fusesource.hawtdb.internal.index.BTreeNode;
import org.fusesource.hawtdb.internal.index.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BTreeIterator<Key, Value>
implements Iterator<Map.Entry<Key, Value>> {
    private final BTreeIndex<Key, Value> index;
    BTreeNode<Key, Value> current;
    int nextIndex;
    Map.Entry<Key, Value> nextEntry;

    BTreeIterator(BTreeIndex<Key, Value> index, BTreeNode<Key, Value> current, int nextIndex) {
        this.index = index;
        this.current = current;
        this.nextIndex = nextIndex;
    }

    private void findNextPage() {
        if (this.nextEntry != null) {
            return;
        }
        while (this.current != null) {
            if (this.nextIndex >= this.current.data.keys.length) {
                if (this.current.data.next < 0) break;
                this.current = this.index.loadNode(null, this.current.data.next);
                this.nextIndex = 0;
                continue;
            }
            this.nextEntry = new MapEntry(this.current.data.keys[this.nextIndex], this.current.data.values[this.nextIndex]);
            ++this.nextIndex;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNextPage();
        return this.nextEntry != null;
    }

    @Override
    public Map.Entry<Key, Value> next() {
        this.findNextPage();
        if (this.nextEntry != null) {
            Map.Entry<Key, Value> lastEntry = this.nextEntry;
            this.nextEntry = null;
            return lastEntry;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

