/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.index;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.AbstractStreamPagedAccessor;
import org.fusesource.hawtdb.api.IndexException;
import org.fusesource.hawtdb.api.IndexVisitor;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.api.Predicate;
import org.fusesource.hawtdb.api.Prefixer;
import org.fusesource.hawtdb.internal.index.BTreeIndex;
import org.fusesource.hawtdb.internal.index.BTreeIterator;
import org.fusesource.hawtdb.internal.index.BTreePredicateIterator;
import org.fusesource.hawtdb.internal.index.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BTreeNode<Key, Value> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Data EMPTY_DATA = new Data();
    public static final Buffer BRANCH_MAGIC = new Buffer(new byte[]{98, 98});
    public static final Buffer LEAF_MAGIC = new Buffer(new byte[]{98, 108});
    volatile BTreeNode<Key, Value> parent;
    volatile Data<Key, Value> data;
    volatile int page;
    volatile boolean storedInExtent;

    static <Key, Value> int estimatedSize(BTreeIndex<Key, Value> index, Data<Key, Value> data) {
        int rc = 6;
        int v = index.getKeyMarshaller().getFixedSize();
        if (v >= 0) {
            rc += v * data.keys.length;
        } else {
            for (Object key : data.keys) {
                rc += index.getKeyMarshaller().estimatedSize(key);
            }
        }
        if (data.isBranch()) {
            rc += 4 * data.children.length;
        } else {
            v = index.getValueMarshaller().getFixedSize();
            if (v >= 0) {
                rc += v * data.values.length;
            } else {
                for (Object value : data.values) {
                    rc += index.getValueMarshaller().estimatedSize(value);
                }
            }
            rc += 4;
        }
        return rc;
    }

    static <Key, Value> void write(DataOutput os, BTreeIndex<Key, Value> index, Data<Key, Value> data) throws IOException {
        int i;
        if (data.isBranch()) {
            os.write(BTreeNode.BRANCH_MAGIC.data, BTreeNode.BRANCH_MAGIC.offset, BTreeNode.BRANCH_MAGIC.length);
        } else {
            os.write(BTreeNode.LEAF_MAGIC.data, BTreeNode.LEAF_MAGIC.offset, BTreeNode.LEAF_MAGIC.length);
        }
        int count = data.keys.length;
        os.writeShort(count);
        for (i = 0; i < data.keys.length; ++i) {
            index.getKeyMarshaller().encode(data.keys[i], os);
        }
        if (data.isBranch()) {
            for (i = 0; i < count + 1; ++i) {
                os.writeInt(data.children[i]);
            }
        } else {
            for (i = 0; i < count; ++i) {
                index.getValueMarshaller().encode(data.values[i], os);
            }
            os.writeInt(data.next);
        }
    }

    static <Key, Value> Data<Key, Value> read(DataInput is, BTreeIndex<Key, Value> index) throws IOException {
        int i;
        boolean branch;
        Buffer magic = new Buffer(BTreeNode.BRANCH_MAGIC.length);
        is.readFully(magic.data, magic.offset, magic.length);
        if (magic.equals(BRANCH_MAGIC)) {
            branch = true;
        } else if (magic.equals(LEAF_MAGIC)) {
            branch = false;
        } else {
            throw new IndexException("Page did not contain the expected btree headers");
        }
        int count = is.readShort();
        Object[] keys = new Object[count];
        int[] children = null;
        Object[] values = null;
        int next = -1;
        for (i = 0; i < count; ++i) {
            keys[i] = index.getKeyMarshaller().decode(is);
        }
        if (branch) {
            children = new int[count + 1];
            for (i = 0; i < count + 1; ++i) {
                children[i] = is.readInt();
            }
        } else {
            values = new Object[count];
            for (i = 0; i < count; ++i) {
                values[i] = index.getValueMarshaller().decode(is);
            }
            next = is.readInt();
        }
        return new Data<Object, Object>(keys, children, values, next);
    }

    public BTreeNode(BTreeNode<Key, Value> parent, int page) {
        this(parent, page, EMPTY_DATA);
    }

    public BTreeNode(BTreeNode<Key, Value> parent, int page, Data<Key, Value> data) {
        this.parent = parent;
        this.page = page;
        this.data = data;
    }

    BTreeNode<Key, Value> getChild(BTreeIndex<Key, Value> index, int idx) {
        if (this.data.isBranch() && idx >= 0 && idx < this.data.children.length) {
            BTreeNode<Key, Value> result = index.loadNode(this, this.data.children[idx]);
            return result;
        }
        return null;
    }

    private BTreeNode<Key, Value> getRightLeaf(BTreeIndex<Key, Value> index) {
        BTreeNode<Key, Value> cur = this;
        while (cur.isBranch()) {
            cur = cur.getChild(index, cur.data.keys.length);
        }
        return cur;
    }

    private BTreeNode<Key, Value> getLeftLeaf(BTreeIndex<Key, Value> index) {
        BTreeNode<Key, Value> cur = this;
        while (cur.isBranch()) {
            cur = cur.getChild(index, 0);
        }
        return cur;
    }

    private BTreeNode<Key, Value> getLeftPeer(BTreeIndex<Key, Value> index, BTreeNode<Key, Value> x) {
        BTreeNode<Key, Value> cur = x;
        while (cur.parent != null) {
            if (cur.parent.data.children[0] == cur.page) {
                cur = cur.parent;
                continue;
            }
            for (int i = 0; i < cur.parent.data.children.length; ++i) {
                if (cur.parent.data.children[i] != cur.page) continue;
                return cur.parent.getChild(index, i - 1);
            }
            throw new AssertionError((Object)("page " + x + " was dependent of " + cur.page));
        }
        return null;
    }

    public Value remove(BTreeIndex<Key, Value> index, Key key) {
        if (this.data.isBranch()) {
            int idx = Arrays.binarySearch(this.data.keys, key, index.getComparator());
            idx = idx < 0 ? -(idx + 1) : idx + 1;
            BTreeNode<Key, Value> child = this.getChild(index, idx);
            if (child.getPage() == index.getIndexLocation()) {
                throw new IndexException("BTree corrupted: Cylce detected.");
            }
            Value rc = child.remove(index, key);
            if (child.data.keys.length == 0) {
                if (child.data.isBranch()) {
                    this.data = this.data.children(BTreeNode.arrayUpdate(this.data.children, idx, child.data.children[0]));
                } else {
                    BTreeNode<Key, Value> previousLeaf = null;
                    if (idx > 0) {
                        previousLeaf = super.getRightLeaf(index);
                    } else {
                        BTreeNode<Key, Value> lp = this.getLeftPeer(index, this);
                        if (lp != null) {
                            previousLeaf = super.getRightLeaf(index);
                        }
                    }
                    if (previousLeaf != null) {
                        super.setNext(index, child.data.next);
                    }
                    this.data = idx < this.data.children.length - 1 ? this.data.branch(BTreeNode.arrayDelete(this.data.keys, idx), BTreeNode.arrayDelete(this.data.children, idx)) : this.data.branch(BTreeNode.arrayDelete(this.data.keys, idx - 1), BTreeNode.arrayDelete(this.data.children, idx));
                    if (this.data.children.length == 1 && this.parent == null) {
                        child = this.getChild(index, 0);
                        this.data = this.data.change(child.data.keys, child.data.children, child.data.values);
                        index.free(child);
                    }
                }
                index.storeNode(this);
            }
            return rc;
        }
        int idx = Arrays.binarySearch(this.data.keys, key, index.getComparator());
        if (idx < 0) {
            return null;
        }
        Object oldValue = this.data.values[idx];
        this.data = this.data.leaf(BTreeNode.arrayDelete(this.data.keys, idx), BTreeNode.arrayDelete(this.data.values, idx));
        if (this.data.keys.length == 0 && this.parent != null) {
            index.free(this);
        } else {
            index.storeNode(this);
        }
        return oldValue;
    }

    private void setNext(BTreeIndex<Key, Value> index, int next) {
        this.data = this.data.next(next);
        index.storeNode(this);
    }

    public Value put(BTreeIndex<Key, Value> index, Key key, Value value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.data.isBranch()) {
            return BTreeNode.getLeafNode(index, this, key).put(index, key, value);
        }
        int idx = Arrays.binarySearch(this.data.keys, key, index.getComparator());
        Value oldValue = null;
        if (idx >= 0) {
            oldValue = this.data.values[idx];
            this.data = this.data.leaf(this.data.keys, BTreeNode.arrayUpdate(this.data.values, idx, value));
        } else {
            idx = -(idx + 1);
            this.data = this.data.leaf(BTreeNode.arrayInsert(this.data.keys, key, idx), BTreeNode.arrayInsert(this.data.values, value, idx));
        }
        if (!index.storeNode(this)) {
            this.split(index);
        }
        return oldValue;
    }

    public Value putIfAbsent(BTreeIndex<Key, Value> index, Key key, Value value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.data.isBranch()) {
            return BTreeNode.getLeafNode(index, this, key).putIfAbsent(index, key, value);
        }
        int idx = Arrays.binarySearch(this.data.keys, key, index.getComparator());
        if (idx >= 0) {
            return this.data.values[idx];
        }
        idx = -(idx + 1);
        this.data = this.data.leaf(BTreeNode.arrayInsert(this.data.keys, key, idx), BTreeNode.arrayInsert(this.data.values, value, idx));
        if (!index.storeNode(this)) {
            this.split(index);
        }
        return null;
    }

    private void promoteValue(BTreeIndex<Key, Value> index, Key key, int nodeId) {
        int idx = Arrays.binarySearch(this.data.keys, key, index.getComparator());
        idx = idx < 0 ? -(idx + 1) : idx + 1;
        this.data = this.data.branch(BTreeNode.arrayInsert(this.data.keys, key, idx), BTreeNode.arrayInsert(this.data.children, nodeId, idx + 1));
        if (!index.storeNode(this)) {
            this.split(index);
        }
    }

    private void split(BTreeIndex<Key, Value> index) {
        Key separator;
        Key[] rightKeys;
        Key[] leftKeys;
        Value[] leftValues = null;
        Value[] rightValues = null;
        int[] leftChildren = null;
        int[] rightChildren = null;
        int vc = this.data.keys.length;
        int pivot = vc / 2;
        if (this.data.isBranch()) {
            leftKeys = this.createKeyArray(pivot);
            leftChildren = new int[leftKeys.length + 1];
            rightKeys = this.createKeyArray(vc - (pivot + 1));
            rightChildren = new int[rightKeys.length + 1];
            System.arraycopy(this.data.keys, 0, leftKeys, 0, leftKeys.length);
            System.arraycopy(this.data.children, 0, leftChildren, 0, leftChildren.length);
            System.arraycopy(this.data.keys, leftKeys.length + 1, rightKeys, 0, rightKeys.length);
            System.arraycopy(this.data.children, leftChildren.length, rightChildren, 0, rightChildren.length);
            Prefixer<Key> prefixer = index.getPrefixer();
            separator = prefixer != null ? prefixer.getSimplePrefix(leftKeys[leftKeys.length - 1], rightKeys[0]) : this.data.keys[leftKeys.length];
        } else {
            leftKeys = this.createKeyArray(pivot);
            leftValues = this.createValueArray(leftKeys.length);
            rightKeys = this.createKeyArray(vc - pivot);
            rightValues = this.createValueArray(rightKeys.length);
            System.arraycopy(this.data.keys, 0, leftKeys, 0, leftKeys.length);
            System.arraycopy(this.data.values, 0, leftValues, 0, leftValues.length);
            System.arraycopy(this.data.keys, leftKeys.length, rightKeys, 0, rightKeys.length);
            System.arraycopy(this.data.values, leftValues.length, rightValues, 0, rightValues.length);
            separator = rightKeys[0];
        }
        if (this.parent == null) {
            BTreeNode<Key, Value> lNode = index.createNode(this);
            BTreeNode<Key, Value> rNode = index.createNode(this);
            if (this.data.isBranch()) {
                rNode.data = this.data.branch(rightKeys, rightChildren);
                lNode.data = this.data.branch(leftKeys, leftChildren);
            } else {
                rNode.data = this.data.leaf(rightKeys, rightValues);
                lNode.data = this.data.leaf(leftKeys, leftValues, rNode.getPage());
            }
            Key[] v = this.createKeyArray(1);
            v[0] = separator;
            this.data = this.data.branch(v, new int[]{lNode.getPage(), rNode.getPage()});
            index.storeNode(this);
            index.storeNode(rNode);
            index.storeNode(lNode);
        } else {
            BTreeNode<Key, Value> rNode;
            if (this.data.isBranch()) {
                rNode = index.createNode(this.parent, this.data.branch(rightKeys, rightChildren));
                this.data = this.data.branch(leftKeys, leftChildren);
            } else {
                rNode = index.createNode(this.parent, this.data.leaf(rightKeys, rightValues, this.data.next));
                this.data = this.data.leaf(leftKeys, leftValues, rNode.getPage());
            }
            index.storeNode(this);
            index.storeNode(rNode);
            super.promoteValue(index, separator, rNode.getPage());
        }
    }

    public void printStructure(BTreeIndex<Key, Value> index, PrintWriter out, String firstLinePrefix, String prefix) {
        if (prefix.length() > 0 && this.parent == null) {
            throw new IllegalStateException("Cycle back to root node detected.");
        }
        if (this.data.isBranch()) {
            out.println(firstLinePrefix + "branch @ " + this.page + " contains " + this.data.keys.length + " keys");
            for (int i = 0; i < this.data.children.length; ++i) {
                BTreeNode<Key, Value> child = this.getChild(index, i);
                if (i < this.data.keys.length) {
                    child.printStructure(index, out, prefix + "|-+ ", prefix + "|   ");
                } else {
                    child.printStructure(index, out, prefix + "\\-+ ", prefix + "    ");
                }
                if (i >= this.data.keys.length) continue;
                out.println(prefix + ": " + this.data.keys[i]);
            }
        } else {
            out.println(firstLinePrefix + "leaf @ " + this.page + " contains " + this.data.keys.length + " keys");
            for (int i = 0; i < this.data.keys.length; ++i) {
                out.println(prefix + ": " + this.data.keys[i]);
            }
        }
    }

    public int getMinLeafDepth(BTreeIndex<Key, Value> index, int depth) {
        ++depth;
        if (this.data.isBranch()) {
            int min = Integer.MAX_VALUE;
            for (int i = 0; i < this.data.children.length; ++i) {
                min = Math.min(min, this.getChild(index, i).getMinLeafDepth(index, depth));
            }
            return min;
        }
        return depth;
    }

    public int size(BTreeIndex<Key, Value> index) {
        int rc = 0;
        BTreeNode<Key, Value> node = this;
        while (node.data.isBranch()) {
            node = node.getChild(index, 0);
        }
        while (node != null) {
            rc += node.data.values.length;
            if (node.data.next != -1) {
                node = index.loadNode(null, node.data.next);
                continue;
            }
            node = null;
        }
        return rc;
    }

    public boolean isEmpty(BTreeIndex<Key, Value> index) {
        return this.data.keys.length == 0;
    }

    public int getMaxLeafDepth(BTreeIndex<Key, Value> index, int depth) {
        ++depth;
        if (this.data.isBranch()) {
            int v = 0;
            for (int i = 0; i < this.data.children.length; ++i) {
                v = Math.max(v, this.getChild(index, i).getMaxLeafDepth(index, depth));
            }
            depth = v;
        }
        return depth;
    }

    public Value get(BTreeIndex<Key, Value> index, Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.data.isBranch()) {
            return BTreeNode.getLeafNode(index, this, key).get(index, key);
        }
        int idx = Arrays.binarySearch(this.data.keys, key, index.getComparator());
        if (idx < 0) {
            return null;
        }
        return this.data.values[idx];
    }

    public void visit(BTreeIndex<Key, Value> index, IndexVisitor<Key, Value> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor cannot be null");
        }
        if (visitor.isSatiated()) {
            return;
        }
        if (this.data.isBranch()) {
            for (int i = 0; i < this.data.children.length; ++i) {
                Object key1 = null;
                if (i != 0) {
                    key1 = this.data.keys[i - 1];
                }
                Object key2 = null;
                if (i != this.data.children.length - 1) {
                    key2 = this.data.keys[i];
                }
                if (!visitor.isInterestedInKeysBetween(key1, key2, index.getComparator())) continue;
                BTreeNode<Object, Value> child = this.getChild(index, i);
                child.visit(index, visitor);
            }
        } else {
            visitor.visit(Arrays.asList(this.data.keys), Arrays.asList(this.data.values), index.getComparator());
        }
    }

    public Map.Entry<Key, Value> getFirst(BTreeIndex<Key, Value> index) {
        BTreeNode<Key, Value> node = this;
        while (node.data.isBranch()) {
            node = node.getChild(index, 0);
        }
        if (node.data.values.length > 0) {
            return new MapEntry(node.data.keys[0], node.data.values[0]);
        }
        return null;
    }

    public Map.Entry<Key, Value> getLast(BTreeIndex<Key, Value> index) {
        BTreeNode<Key, Value> node = this;
        while (node.data.isBranch()) {
            node = node.getChild(index, node.data.children.length - 1);
        }
        if (node.data.values.length > 0) {
            int idx = node.data.values.length - 1;
            return new MapEntry(node.data.keys[idx], node.data.values[idx]);
        }
        return null;
    }

    public BTreeNode<Key, Value> getFirstLeafNode(BTreeIndex<Key, Value> index) {
        BTreeNode<Key, Value> node = this;
        while (node.data.isBranch()) {
            node = node.getChild(index, 0);
        }
        return node;
    }

    public Iterator<Map.Entry<Key, Value>> iterator(BTreeIndex<Key, Value> index, Predicate<Key> predicate) {
        return new BTreePredicateIterator<Key, Value>(index, this, predicate);
    }

    public Iterator<Map.Entry<Key, Value>> iterator(BTreeIndex<Key, Value> index, Key startKey) {
        if (startKey == null) {
            return this.iterator(index);
        }
        if (this.data.isBranch()) {
            return BTreeNode.getLeafNode(index, this, startKey).iterator(index, startKey);
        }
        int idx = Arrays.binarySearch(this.data.keys, startKey, index.getComparator());
        if (idx < 0) {
            idx = -(idx + 1);
        }
        return new BTreeIterator<Key, Value>(index, this, idx);
    }

    public Iterator<Map.Entry<Key, Value>> iterator(BTreeIndex<Key, Value> index) {
        return new BTreeIterator<Key, Value>(index, this.getFirstLeafNode(index), 0);
    }

    public void clear(BTreeIndex<Key, Value> index) {
        if (this.data.isBranch()) {
            for (int i = 0; i < this.data.children.length; ++i) {
                BTreeNode<Key, Value> node = index.loadNode(this, this.data.children[i]);
                node.clear(index);
                index.free(node);
            }
        }
        if (this.parent == null) {
            this.data = this.data.leaf(EMPTY_ARRAY, EMPTY_ARRAY, -1);
            index.storeNode(this);
        }
    }

    private static <Key, Value> BTreeNode<Key, Value> getLeafNode(BTreeIndex<Key, Value> index, BTreeNode<Key, Value> node, Key key) {
        BTreeNode<Key, Value> current = node;
        while (current.data.isBranch()) {
            int idx = Arrays.binarySearch(current.data.keys, key, index.getComparator());
            idx = idx < 0 ? -(idx + 1) : idx + 1;
            BTreeNode<Key, Value> child = current.getChild(index, idx);
            if (child == node) {
                throw new IndexException("BTree corrupted: Cylce detected.");
            }
            current = child;
        }
        return current;
    }

    public boolean contains(BTreeIndex<Key, Value> index, Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.data.isBranch()) {
            return BTreeNode.getLeafNode(index, this, key).contains(index, key);
        }
        int idx = Arrays.binarySearch(this.data.keys, key, index.getComparator());
        return idx >= 0;
    }

    boolean allowPageOverflow() {
        return this.data.keys.length < 4;
    }

    private Key[] createKeyArray(int size) {
        return new Object[size];
    }

    private Value[] createValueArray(int size) {
        return new Object[size];
    }

    private static <T> T[] arrayUpdate(T[] vals, int idx, T value) {
        Object[] newVals = new Object[vals.length];
        System.arraycopy(vals, 0, newVals, 0, vals.length);
        newVals[idx] = value;
        return newVals;
    }

    private static int[] arrayUpdate(int[] vals, int idx, int value) {
        int[] newVals = new int[vals.length];
        System.arraycopy(vals, 0, newVals, 0, vals.length);
        newVals[idx] = value;
        return newVals;
    }

    private static <T> T[] arrayDelete(T[] vals, int idx) {
        Object[] newVals = new Object[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    private static int[] arrayDelete(int[] vals, int idx) {
        int[] newVals = new int[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    private static <T> T[] arrayInsert(T[] vals, T val, int idx) {
        Object[] newVals = new Object[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    private static int[] arrayInsert(int[] vals, int val, int idx) {
        int[] newVals = new int[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public BTreeNode<Key, Value> getParent() {
        return this.parent;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getNext() {
        return this.data.next;
    }

    public String toString() {
        return "{ page: " + this.page + ", data: " + this.data.toString() + " }";
    }

    public boolean isLeaf() {
        return !this.data.isBranch();
    }

    public boolean isBranch() {
        return this.data.isBranch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataPagedAccessor<Key, Value>
    extends AbstractStreamPagedAccessor<Data<Key, Value>> {
        private final BTreeIndex<Key, Value> index;

        public DataPagedAccessor(BTreeIndex<Key, Value> index) {
            this.index = index;
        }

        @Override
        protected void encode(Paged paged, DataOutputStream os, Data<Key, Value> data) throws IOException {
            BTreeNode.write(os, this.index, data);
        }

        @Override
        protected Data<Key, Value> decode(Paged paged, DataInputStream is) throws IOException {
            return BTreeNode.read(is, this.index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Data<Key, Value> {
        final Key[] keys;
        final Value[] values;
        final int[] children;
        final int next;

        public Data() {
            this(EMPTY_ARRAY, null, EMPTY_ARRAY, -1);
        }

        public Data(Key[] keys, int[] children, Value[] values, int next) {
            this.keys = keys;
            this.values = values;
            this.children = children;
            this.next = next;
        }

        public String toString() {
            return "{ next: " + this.next + ", type: " + (this.isBranch() ? "branch" : "leaf") + ", keys: " + Arrays.toString(this.keys) + " }";
        }

        public boolean isBranch() {
            return this.children != null;
        }

        public Data<Key, Value> values(Value[] values) {
            return new Data<Key, Value>(this.keys, this.children, values, this.next);
        }

        public Data<Key, Value> children(int[] children) {
            return new Data<Key, Value>(this.keys, children, this.values, this.next);
        }

        public Data<Key, Value> next(int next) {
            return new Data<Key, Value>(this.keys, this.children, this.values, next);
        }

        public Data<Key, Value> change(Key[] keys, int[] children, Value[] values) {
            return new Data<Key, Value>(keys, children, values, this.next);
        }

        public Data<Key, Value> branch(Key[] keys, int[] children) {
            return new Data<Key, Value>(keys, children, null, this.next);
        }

        public Data<Key, Value> leaf(Key[] keys, Value[] values) {
            return new Data<Key, Value>(keys, null, values, this.next);
        }

        public Data<Key, Value> leaf(Key[] keys, Value[] values, int next) {
            return new Data<Key, Value>(keys, null, values, next);
        }
    }
}

