/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.index;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Logging {
    private static final Log LOG = LogFactory.getLog(Logging.class);

    public static void trace(String message, Object ... args) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format(message, args));
        }
    }

    public static void debug(String message, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format(message, args));
        }
    }

    public static void warn(String message, Object ... args) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)String.format(message, args));
        }
    }

    public static void warn(Throwable e, String message, Object ... args) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)String.format(message, args), e);
        }
    }

    public static void error(String message, Object ... args) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)String.format(message, args));
        }
    }
}

