/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.io.IOException;
import java.io.OutputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.internal.page.Extent;
import org.fusesource.hawtdb.internal.util.Ranges;

public class ExtentOutputStream
extends OutputStream {
    private static final short DEFAULT_EXTENT_SIZE = 128;
    private final Paged paged;
    private final short extentSize;
    private final int page;
    private Extent current;
    private Ranges pages = new Ranges();

    public ExtentOutputStream(Paged paged) {
        this(paged, 128);
    }

    public ExtentOutputStream(Paged paged, short extentSize) {
        this(paged, paged.allocator().alloc(extentSize), extentSize, extentSize);
    }

    public ExtentOutputStream(Paged paged, int page, short extentSize, short nextExtentSize) {
        this.paged = paged;
        this.extentSize = nextExtentSize;
        this.page = page;
        this.current = new Extent(paged, page);
        this.current.writeOpen(extentSize);
    }

    public String toString() {
        return "{ page: " + this.page + ", extent size: " + this.extentSize + ", current: " + this.current + " }";
    }

    public void write(int b) throws IOException {
        if (!this.current.write((byte)b)) {
            int nextPageId = this.paged.allocator().alloc(this.extentSize);
            this.current.writeCloseLinked(nextPageId);
            this.pages.add(this.current.getPage(), this.paged.pages(this.current.getLength()));
            this.current = new Extent(this.paged, nextPageId);
            this.current.writeOpen(this.extentSize);
            this.current.write((byte)b);
        }
    }

    public void write(byte[] b, int off, int len) {
        Buffer buffer = new Buffer(b, off, len);
        while (buffer.length > 0) {
            if (this.current.write(buffer)) continue;
            int nextPageId = this.paged.allocator().alloc(this.extentSize);
            this.current.writeCloseLinked(nextPageId);
            this.pages.add(this.current.getPage(), this.paged.pages(this.current.getLength()));
            this.current = new Extent(this.paged, nextPageId);
            this.current.writeOpen(this.extentSize);
        }
    }

    public short getExtentSize() {
        return this.extentSize;
    }

    public int getPage() {
        return this.page;
    }

    public void close() {
        this.current.writeCloseEOF();
        this.pages.add(this.current.getPage(), this.paged.pages(this.current.getLength()));
    }

    public Ranges getPages() {
        return this.pages;
    }
}

