/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.api;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.fusesource.hawtdb.api.IndexVisitor;
import org.fusesource.hawtdb.api.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    public static <Key> Predicate<Key> none() {
        return new NonePredicate();
    }

    public static <Key> Predicate<Key> all() {
        return new AllPredicate();
    }

    public static <Key> Predicate<Key> or(Predicate<Key> ... conditions) {
        return new OrPredicate<Key>(Arrays.asList(conditions));
    }

    public static <Key> Predicate<Key> or(List<Predicate<Key>> conditions) {
        return new OrPredicate<Key>(conditions);
    }

    public static <Key> Predicate<Key> and(Predicate<Key> ... conditions) {
        return new AndPredicate<Key>(Arrays.asList(conditions));
    }

    public static <Key> Predicate<Key> and(List<Predicate<Key>> conditions) {
        return new AndPredicate<Key>(conditions);
    }

    public static <Key> Predicate<Key> gt(Key key) {
        return new GTPredicate<Key>(key);
    }

    public static <Key> Predicate<Key> gte(Key key) {
        return new GTEPredicate<Key>(key);
    }

    public static <Key> Predicate<Key> lt(Key key) {
        return new LTPredicate<Key>(key);
    }

    public static <Key> Predicate<Key> lte(Key key) {
        return new LTEPredicate<Key>(key);
    }

    public static <Key> Predicate<Key> lte(Key first, Key last) {
        return new BetweenPredicate<Key>(first, last);
    }

    public static <Key, Value> IndexVisitor<Key, Value> visitor(Predicate<Key> predicate) {
        return new PredicateVisitor(predicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PredicateVisitor<Key, Value>
    implements IndexVisitor<Key, Value> {
        public static final int UNLIMITED = -1;
        private final Predicate<Key> predicate;
        private int limit;

        public PredicateVisitor(Predicate<Key> predicate) {
            this(predicate, -1);
        }

        public PredicateVisitor(Predicate<Key> predicate, int limit) {
            this.predicate = predicate;
            this.limit = limit;
        }

        @Override
        public final void visit(List<Key> keys, List<Value> values, Comparator comparator) {
            for (int i = 0; i < keys.size() && !this.isSatiated(); ++i) {
                Key key = keys.get(i);
                if (!this.predicate.isInterestedInKey(key, comparator)) continue;
                if (this.limit > 0) {
                    --this.limit;
                }
                this.matched(key, values.get(i));
            }
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            return this.predicate.isInterestedInKeysBetween(first, second, comparator);
        }

        @Override
        public boolean isSatiated() {
            return this.limit == 0;
        }

        protected void matched(Key key, Value value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NonePredicate<Key>
    implements Predicate<Key> {
        NonePredicate() {
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            return false;
        }

        @Override
        public boolean isInterestedInKey(Key key, Comparator comparator) {
            return false;
        }

        public String toString() {
            return "none";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AllPredicate<Key>
    implements Predicate<Key> {
        AllPredicate() {
        }

        @Override
        public boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            return true;
        }

        @Override
        public boolean isInterestedInKey(Key key, Comparator comparator) {
            return true;
        }

        public String toString() {
            return "all";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LTEPredicate<Key>
    extends ComparingPredicate<Key> {
        private final Key value;

        public LTEPredicate(Key value) {
            this.value = value;
        }

        @Override
        public final boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            return first == null || this.isInterestedInKey(first, comparator);
        }

        @Override
        public final boolean isInterestedInKey(Key key, Comparator comparator) {
            return this.compare(key, this.value, comparator) <= 0;
        }

        public String toString() {
            return "key <= " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LTPredicate<Key>
    extends ComparingPredicate<Key> {
        private final Key value;

        public LTPredicate(Key value) {
            this.value = value;
        }

        @Override
        public final boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            return first == null || this.isInterestedInKey(first, comparator);
        }

        @Override
        public final boolean isInterestedInKey(Key key, Comparator comparator) {
            return this.compare(key, this.value, comparator) < 0;
        }

        public String toString() {
            return "key < " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GTEPredicate<Key>
    extends ComparingPredicate<Key> {
        private final Key value;

        public GTEPredicate(Key value) {
            this.value = value;
        }

        @Override
        public final boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            return second == null || this.isInterestedInKey(second, comparator);
        }

        @Override
        public final boolean isInterestedInKey(Key key, Comparator comparator) {
            return this.compare(key, this.value, comparator) >= 0;
        }

        public String toString() {
            return "key >= " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GTPredicate<Key>
    extends ComparingPredicate<Key> {
        private final Key value;

        public GTPredicate(Key value) {
            this.value = value;
        }

        @Override
        public final boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            return second == null || this.isInterestedInKey(second, comparator);
        }

        @Override
        public final boolean isInterestedInKey(Key key, Comparator comparator) {
            return this.compare(key, this.value, comparator) > 0;
        }

        public String toString() {
            return "key > " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BetweenPredicate<Key>
    extends ComparingPredicate<Key> {
        private final Key first;
        private final Key last;

        public BetweenPredicate(Key first, Key last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public final boolean isInterestedInKeysBetween(Key left, Key right, Comparator comparator) {
            return !(right != null && this.compare(right, this.first, comparator) < 0 || left != null && this.compare(left, this.last, comparator) >= 0);
        }

        @Override
        public final boolean isInterestedInKey(Key key, Comparator comparator) {
            return this.compare(key, this.first, comparator) >= 0 && this.compare(key, this.last, comparator) < 0;
        }

        public String toString() {
            return this.first + " <= key < " + this.last;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ComparingPredicate<Key>
    implements Predicate<Key> {
        ComparingPredicate() {
        }

        public final int compare(Key key, Key value, Comparator comparator) {
            if (comparator == null) {
                return ((Comparable)key).compareTo(value);
            }
            return comparator.compare(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AndPredicate<Key>
    implements Predicate<Key> {
        private final List<Predicate<Key>> conditions;

        public AndPredicate(List<Predicate<Key>> conditions) {
            this.conditions = conditions;
        }

        @Override
        public final boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            for (Predicate<Key> condition : this.conditions) {
                if (condition.isInterestedInKeysBetween(first, second, comparator)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean isInterestedInKey(Key key, Comparator comparator) {
            for (Predicate<Key> condition : this.conditions) {
                if (condition.isInterestedInKey(key, comparator)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Predicate<Key> condition : this.conditions) {
                if (!first) {
                    sb.append(" AND ");
                }
                first = false;
                sb.append("(");
                sb.append(condition);
                sb.append(")");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrPredicate<Key>
    implements Predicate<Key> {
        private final List<Predicate<Key>> conditions;

        public OrPredicate(List<Predicate<Key>> conditions) {
            this.conditions = conditions;
        }

        @Override
        public final boolean isInterestedInKeysBetween(Key first, Key second, Comparator comparator) {
            for (Predicate<Key> condition : this.conditions) {
                if (!condition.isInterestedInKeysBetween(first, second, comparator)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean isInterestedInKey(Key key, Comparator comparator) {
            for (Predicate<Key> condition : this.conditions) {
                if (!condition.isInterestedInKey(key, comparator)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Predicate<Key> condition : this.conditions) {
                if (!first) {
                    sb.append(" OR ");
                }
                first = false;
                sb.append("(");
                sb.append(condition);
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

