/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.api;

import java.io.File;
import java.io.IOException;
import org.fusesource.hawtdb.api.PageFileFactory;
import org.fusesource.hawtdb.api.TxPageFile;
import org.fusesource.hawtdb.internal.page.HawtPageFile;
import org.fusesource.hawtdb.internal.page.HawtTxPageFile;
import org.fusesource.hawtdb.internal.page.LFUPageCache;
import org.fusesource.hawtdb.internal.page.PageCache;

public class TxPageFileFactory {
    private final PageFileFactory pageFileFactory = new PageFileFactory();
    private HawtTxPageFile txPageFile;
    protected boolean drainOnClose;
    protected boolean sync = true;
    protected boolean useWorkerThread;
    private PageCache pageCache = new LFUPageCache(1024, 0.5f);

    public TxPageFileFactory() {
        this.pageFileFactory.setHeaderSize(4096);
        this.pageFileFactory.setStoreFreePages(false);
    }

    public void open() {
        if (this.getFile() == null) {
            throw new IllegalArgumentException("file property not set");
        }
        boolean existed = this.getFile().isFile();
        this.pageFileFactory.open();
        if (this.txPageFile == null) {
            this.txPageFile = new HawtTxPageFile(this, (HawtPageFile)this.pageFileFactory.getPageFile());
            if (existed) {
                this.txPageFile.recover();
            } else {
                this.txPageFile.reset();
            }
        }
    }

    public void close() throws IOException {
        if (this.txPageFile != null) {
            this.txPageFile.close();
            this.txPageFile = null;
        }
        this.pageFileFactory.close();
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public TxPageFile getTxPageFile() {
        return this.txPageFile;
    }

    public boolean isDrainOnClose() {
        return this.drainOnClose;
    }

    public void setDrainOnClose(boolean drainOnClose) {
        this.drainOnClose = drainOnClose;
    }

    public boolean isUseWorkerThread() {
        return this.useWorkerThread;
    }

    public void setUseWorkerThread(boolean useWorkerThread) {
        this.useWorkerThread = useWorkerThread;
    }

    public File getFile() {
        return this.pageFileFactory.getFile();
    }

    public int getMappingSegementSize() {
        return this.pageFileFactory.getMappingSegementSize();
    }

    public int getMaxPages() {
        return this.pageFileFactory.getMaxPages();
    }

    public short getPageSize() {
        return this.pageFileFactory.getPageSize();
    }

    public void setFile(File file) {
        this.pageFileFactory.setFile(file);
    }

    public void setMappingSegementSize(int mappingSegementSize) {
        this.pageFileFactory.setMappingSegementSize(mappingSegementSize);
    }

    public void setMaxFileSize(long size) {
        this.pageFileFactory.setMaxFileSize(size);
    }

    public void setMaxPages(int maxPages) {
        this.pageFileFactory.setMaxPages(maxPages);
    }

    public void setPageSize(short pageSize) {
        this.pageFileFactory.setPageSize(pageSize);
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(PageCache pageCache) {
        this.pageCache = pageCache;
    }
}

