/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdb.api.IOPagingException;
import org.fusesource.hawtdb.util.IOHelper;

public final class MemoryMappedFile {
    private final ByteBufferReleaser BYTE_BUFFER_RELEASER = MemoryMappedFile.createByteBufferReleaser();
    private final int bufferSize;
    private final boolean readOnly;
    private final ArrayList<MappedByteBuffer> buffers = new ArrayList(10);
    private final FileChannel channel;
    private final FileDescriptor fd;
    private final HashSet<ByteBuffer> bounderyBuffers = new HashSet(10);

    public MemoryMappedFile(File file, int bufferSize, boolean readOnly) throws IOException {
        this.bufferSize = bufferSize;
        this.readOnly = readOnly;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.fd = randomAccessFile.getFD();
        this.channel = randomAccessFile.getChannel();
    }

    public void read(long position, byte[] data) throws IOPagingException {
        this.read(position, data, 0, data.length);
    }

    public void read(long position, Buffer data) throws IOPagingException {
        this.read(position, data.data, data.offset, data.length);
    }

    public void read(long position, byte[] data, int offset, int length) throws IOPagingException {
        int bufferIndex = (int)(position / (long)this.bufferSize);
        int bufferOffset = (int)(position % (long)this.bufferSize);
        ByteBuffer buffer = this.loadBuffer(bufferIndex);
        buffer = this.position(buffer, bufferOffset);
        int remaining = buffer.remaining();
        while (length > remaining) {
            buffer.get(data, offset, remaining);
            offset += remaining;
            length -= remaining;
            buffer = this.loadBuffer(++bufferIndex).duplicate();
        }
        buffer.get(data, offset, length);
    }

    public ByteBuffer read(long position, int length) throws IOPagingException {
        int bufferIndex = (int)(position / (long)this.bufferSize);
        int bufferOffset = (int)(position % (long)this.bufferSize);
        ByteBuffer buffer = this.loadBuffer(bufferIndex);
        int remaining = (buffer = this.position(buffer, bufferOffset)).remaining();
        if (length > remaining) {
            byte[] data = new byte[length];
            this.read(position, data);
            return ByteBuffer.wrap(data);
        }
        return (ByteBuffer)buffer.limit(buffer.position() + length);
    }

    public ByteBuffer slice(boolean readOnly, long position, int length) {
        if (this.readOnly && !readOnly) {
            throw new IOPagingException("read only");
        }
        int bufferIndex = (int)(position / (long)this.bufferSize);
        int bufferOffset = (int)(position % (long)this.bufferSize);
        ByteBuffer buffer = this.loadBuffer(bufferIndex);
        int remaining = (buffer = this.position(buffer, bufferOffset)).remaining();
        if (length > remaining) {
            try {
                buffer = this.channel.map(readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, position, length);
                this.bounderyBuffers.add(buffer);
                return buffer;
            }
            catch (IOException e) {
                throw new IOPagingException(e);
            }
        }
        return ((ByteBuffer)buffer.limit(buffer.position() + length)).slice();
    }

    public void unslice(ByteBuffer buffer) {
        if (this.bounderyBuffers.remove(buffer)) {
            this.BYTE_BUFFER_RELEASER.release(buffer);
        }
    }

    public ChannelTransfer readChannelTansfer(int position, int length) throws IOPagingException {
        return new ChannelTransfer(this.channel, position, length);
    }

    public void writeChannelTansfer(long position, ChannelTransfer transfer) throws IOPagingException {
        if (this.readOnly) {
            throw new IOPagingException("read only");
        }
        try {
            this.channel.position(position);
            transfer.writeTo(this.channel);
        }
        catch (IOException e) {
            throw new IOPagingException(e);
        }
    }

    public void write(long position, byte[] data) throws IOPagingException {
        if (this.readOnly) {
            throw new IOPagingException("read only");
        }
        this.write(position, data, 0, data.length);
    }

    public void write(long position, Buffer data) throws IOPagingException {
        if (this.readOnly) {
            throw new IOPagingException("read only");
        }
        this.write(position, data.data, data.offset, data.length);
    }

    public void write(long position, ByteBuffer data) throws IOPagingException {
        if (this.readOnly) {
            throw new IOPagingException("read only");
        }
        int bufferIndex = (int)(position / (long)this.bufferSize);
        int bufferOffset = (int)(position % (long)this.bufferSize);
        ByteBuffer buffer = this.loadBuffer(bufferIndex);
        buffer = this.position(buffer, bufferOffset);
        int remaining = buffer.remaining();
        while (data.remaining() > remaining) {
            int l = data.limit();
            data.limit(data.position() + remaining);
            buffer.put(data);
            data.limit(l);
            buffer = this.loadBuffer(++bufferIndex).duplicate();
        }
        buffer.put(data);
    }

    public void write(long position, byte[] data, int offset, int length) throws IOPagingException {
        if (this.readOnly) {
            throw new IOPagingException("read only");
        }
        int bufferIndex = (int)(position / (long)this.bufferSize);
        int bufferOffset = (int)(position % (long)this.bufferSize);
        ByteBuffer buffer = this.loadBuffer(bufferIndex);
        buffer = this.position(buffer, bufferOffset);
        int remaining = buffer.remaining();
        while (length > remaining) {
            buffer.put(data, offset, remaining);
            offset += remaining;
            length -= remaining;
            buffer = this.loadBuffer(++bufferIndex).duplicate();
        }
        buffer.put(data, offset, length);
    }

    private ByteBuffer position(ByteBuffer buffer, int offset) {
        return (ByteBuffer)buffer.duplicate().position(offset);
    }

    private MappedByteBuffer loadBuffer(int index) throws IOPagingException {
        while (index >= this.buffers.size()) {
            this.buffers.add(null);
        }
        MappedByteBuffer buffer = this.buffers.get(index);
        if (buffer == null) {
            try {
                long position = (long)index * (long)this.bufferSize;
                buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, position, this.bufferSize);
            }
            catch (IllegalArgumentException e) {
                throw new IOPagingException(e);
            }
            catch (IOException e) {
                throw new IOPagingException(e);
            }
            this.buffers.set(index, buffer);
        }
        return buffer;
    }

    public void sync() throws IOPagingException {
        if (this.readOnly) {
            throw new IOPagingException("read only");
        }
        for (MappedByteBuffer buffer : this.buffers) {
            if (buffer == null) continue;
            buffer.force();
        }
        try {
            IOHelper.sync(this.fd);
        }
        catch (IOException e) {
            throw new IOPagingException(e);
        }
    }

    public void close() throws IOPagingException {
        this.sync();
        for (MappedByteBuffer buffer : this.buffers) {
            if (buffer == null) continue;
            this.BYTE_BUFFER_RELEASER.release(buffer);
        }
        this.buffers.clear();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new IOPagingException(e);
        }
    }

    private static ByteBufferReleaser createByteBufferReleaser() {
        final Method[] cleanerMethods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    ByteBuffer buffer = ByteBuffer.allocateDirect(1);
                    Class<?> bufferClazz = buffer.getClass();
                    Method cleanerMethod = bufferClazz.getMethod("cleaner", new Class[0]);
                    cleanerMethod.setAccessible(true);
                    Method cleanMethod = cleanerMethod.getReturnType().getMethod("clean", new Class[0]);
                    return new Method[]{cleanerMethod, cleanMethod};
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        if (cleanerMethods != null) {
            return new ByteBufferReleaser(){

                public void release(ByteBuffer buffer) {
                    try {
                        Object cleaner = cleanerMethods[0].invoke((Object)buffer, new Object[0]);
                        if (cleaner != null) {
                            cleanerMethods[1].invoke(cleaner, new Object[0]);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        return new ByteBufferReleaser(){

            public void release(ByteBuffer buffer) {
            }
        };
    }

    private static interface ByteBufferReleaser {
        public void release(ByteBuffer var1);
    }

    public static class ChannelTransfer {
        private final FileChannel channel;
        private final long position;
        private final long length;

        public ChannelTransfer(FileChannel channel, long position, long length) {
            this.channel = channel;
            this.position = position;
            this.length = length;
        }

        public void writeTo(FileChannel destination) throws IOException {
            this.channel.transferTo(this.position, this.length, destination);
        }
    }
}

