/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.multimap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.impl.DefaultProducer;

public class HazelcastMultimapProducer
extends DefaultProducer {
    private final MultiMap<Object, Object> cache;
    private final HazelcastComponentHelper helper = new HazelcastComponentHelper();

    public HazelcastMultimapProducer(HazelcastInstance hazelcastInstance, Endpoint endpoint, String cacheName) {
        super(endpoint);
        this.cache = hazelcastInstance.getMultiMap(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        String oid = null;
        int operation = -1;
        if (headers.containsKey("CamelHazelcastObjectId")) {
            oid = (String)headers.get("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastOperationType")) {
            operation = headers.get("CamelHazelcastOperationType") instanceof String ? this.helper.lookupOperationNumber((String)headers.get("CamelHazelcastOperationType")) : ((Integer)headers.get("CamelHazelcastOperationType")).intValue();
        }
        switch (operation) {
            case 1: {
                this.put(oid, exchange);
                break;
            }
            case 3: {
                this.get(oid, exchange);
                break;
            }
            case 2: {
                this.delete(oid);
                break;
            }
            case 10: {
                this.removevalue(oid, exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the MULTIMAP cache.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void put(String oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.put(oid, body);
    }

    private void get(String oid, Exchange exchange) {
        exchange.getOut().setBody(this.cache.get(oid));
    }

    private void delete(String oid) {
        this.cache.remove(oid);
    }

    private void removevalue(String oid, Exchange exchange) {
        this.cache.remove(oid, exchange.getIn().getBody());
    }
}

