/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;

public class HazelcastIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    private String repositoryName;
    private IMap<String, Boolean> repo;
    private HazelcastInstance hazelcastInstance;

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance) {
        this(hazelcastInstance, HazelcastIdempotentRepository.class.getSimpleName());
    }

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance, String repositoryName) {
        this.repositoryName = repositoryName;
        this.hazelcastInstance = hazelcastInstance;
    }

    protected void doStart() throws Exception {
        this.repo = this.hazelcastInstance.getMap(this.repositoryName);
    }

    protected void doStop() throws Exception {
    }

    public boolean add(String key) {
        Boolean returned;
        Boolean found = this.repo.get(key);
        return found == null && (returned = this.repo.putIfAbsent(key, false)) == null;
    }

    public boolean confirm(String key) {
        return this.repo.replace(key, false, true);
    }

    public boolean contains(String key) {
        return this.repo.containsKey(key);
    }

    public boolean remove(String key) {
        if (this.contains(key)) {
            this.repo.remove(key);
            return true;
        }
        return false;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

