/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.mapstore.AbstractMapDataStore;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntries;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class WriteBehindStore
extends AbstractMapDataStore<Data, Object> {
    private static final DelayedEntry TRANSIENT = DelayedEntries.emptyDelayedEntry();
    private final long writeDelayTime;
    private final int partitionId;
    private final AtomicInteger flushCounter;
    private final InMemoryFormat inMemoryFormat;
    private final boolean coalesce;
    private WriteBehindQueue<DelayedEntry> writeBehindQueue;
    private WriteBehindProcessor writeBehindProcessor;
    private final ConcurrentMap<Data, DelayedEntry> stagingArea;

    public WriteBehindStore(MapStoreWrapper store, SerializationService serializationService, long writeDelayTime, int partitionId, InMemoryFormat inMemoryFormat, boolean coalesce) {
        super(store, serializationService);
        this.writeDelayTime = writeDelayTime;
        this.partitionId = partitionId;
        this.stagingArea = new ConcurrentHashMap<Data, DelayedEntry>();
        this.flushCounter = new AtomicInteger(0);
        this.inMemoryFormat = inMemoryFormat;
        this.coalesce = coalesce;
    }

    @Override
    public Object add(Data key, Object value, long now) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            value = this.toData(value);
            key = this.toData(key);
        }
        if (!this.coalesce && InMemoryFormat.OBJECT == this.inMemoryFormat) {
            value = this.toData(value);
        }
        long storeTime = now + this.writeDelayTime;
        DelayedEntry<Data, Object> delayedEntry = DelayedEntries.createDefault(key, value, storeTime, this.partitionId);
        this.add(delayedEntry);
        return value;
    }

    public void add(DelayedEntry<Data, Object> delayedEntry) {
        this.writeBehindQueue.addLast(delayedEntry);
        this.stagingArea.put(delayedEntry.getKey(), delayedEntry);
    }

    @Override
    public void addTransient(Data key, long now) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toData(key);
        }
        this.stagingArea.put(key, TRANSIENT);
    }

    @Override
    public Object addBackup(Data key, Object value, long time) {
        return this.add(key, value, time);
    }

    @Override
    public void remove(Data key, long now) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toData(key);
        }
        long storeTime = now + this.writeDelayTime;
        DelayedEntry<Data, Object> delayedEntry = DelayedEntries.createWithoutValue(key, storeTime, this.partitionId);
        this.add(delayedEntry);
    }

    @Override
    public void removeBackup(Data key, long time) {
        this.remove(key, time);
    }

    @Override
    public void clear() {
        this.writeBehindQueue.clear();
        this.stagingArea.clear();
        this.flushCounter.set(0);
    }

    @Override
    public Object load(Data key) {
        DelayedEntry delayedEntry = this.getFromStagingArea(key);
        if (delayedEntry == null) {
            return this.getStore().load(this.toObject(key));
        }
        return this.toObject(delayedEntry.getValue());
    }

    @Override
    public Map loadAll(Collection keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Data, Object> map = new HashMap<Data, Object>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Data dataKey = this.toData(key);
            DelayedEntry delayedEntry = this.getFromStagingArea(dataKey);
            if (delayedEntry == null) continue;
            Object value = delayedEntry.getValue();
            if (value != null) {
                map.put(dataKey, this.toObject(value));
            }
            iterator.remove();
        }
        map.putAll(super.loadAll(keys));
        return map;
    }

    @Override
    public boolean loadable(Data key) {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toData(key);
        }
        return !this.writeBehindQueue.contains(DelayedEntries.createDefault(key, null, -1L, -1));
    }

    @Override
    public int notFinishedOperationsCount() {
        return this.writeBehindQueue.size();
    }

    @Override
    public Object flush(Data key, Object value, boolean backup) {
        DelayedEntry delayedEntry;
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            key = this.toData(key);
            value = this.toData(value);
        }
        if ((delayedEntry = (DelayedEntry)this.stagingArea.get(key)) == TRANSIENT) {
            this.stagingArea.remove(key);
            return null;
        }
        if (this.writeBehindQueue.size() == 0 || !this.writeBehindQueue.contains(DelayedEntries.createWithoutValue(key))) {
            return null;
        }
        this.flushCounter.incrementAndGet();
        return value;
    }

    @Override
    public Collection<Data> flush() {
        return this.writeBehindProcessor.flush(this.writeBehindQueue);
    }

    public WriteBehindQueue<DelayedEntry> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    public void setWriteBehindQueue(WriteBehindQueue<DelayedEntry> writeBehindQueue) {
        this.writeBehindQueue = writeBehindQueue;
    }

    public void setWriteBehindProcessor(WriteBehindProcessor writeBehindProcessor) {
        this.writeBehindProcessor = writeBehindProcessor;
    }

    public AtomicInteger getFlushCounter() {
        return this.flushCounter;
    }

    void removeFromStagingArea(DelayedEntry delayedEntry) {
        if (delayedEntry == null) {
            return;
        }
        Data key = (Data)delayedEntry.getKey();
        this.stagingArea.remove(key, delayedEntry);
    }

    private DelayedEntry getFromStagingArea(Data key) {
        DelayedEntry delayedEntry = (DelayedEntry)this.stagingArea.get(key);
        if (delayedEntry == null || delayedEntry == TRANSIENT) {
            return null;
        }
        return delayedEntry;
    }
}

