/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.atomicnumber;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class HazelcastAtomicnumberProducer
extends HazelcastDefaultProducer {
    private final IAtomicLong atomicnumber;

    public HazelcastAtomicnumberProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String cacheName) {
        super(endpoint);
        this.atomicnumber = hazelcastInstance.getAtomicLong(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        long expectedValue = 0L;
        if (headers.containsKey("CamelHazelcastExpectedValue")) {
            expectedValue = (Long)headers.get("CamelHazelcastExpectedValue");
        }
        int operation = this.lookupOperationNumber(exchange);
        switch (operation) {
            case 20: {
                this.increment(exchange);
                break;
            }
            case 21: {
                this.decrement(exchange);
                break;
            }
            case 24: {
                this.compare(expectedValue, exchange);
                break;
            }
            case 25: {
                this.getAndAdd(exchange);
                break;
            }
            case 22: {
                this.set(exchange);
                break;
            }
            case 3: {
                this.get(exchange);
                break;
            }
            case 23: {
                this.destroy();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the ATOMICNUMBER.", operation, "CamelHazelcastOperationType"));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void get(Exchange exchange) {
        exchange.getOut().setBody((Object)this.atomicnumber.get());
    }

    private void increment(Exchange exchange) {
        exchange.getOut().setBody((Object)this.atomicnumber.incrementAndGet());
    }

    private void decrement(Exchange exchange) {
        exchange.getOut().setBody((Object)this.atomicnumber.decrementAndGet());
    }

    private void compare(long expected, Exchange exchange) {
        long update = (Long)exchange.getIn().getBody(Long.class);
        if (ObjectHelper.isEmpty((Object)expected)) {
            throw new IllegalArgumentException("Expected value must be specified");
        }
        exchange.getOut().setBody((Object)this.atomicnumber.compareAndSet(expected, update));
    }

    private void getAndAdd(Exchange exchange) {
        long delta = (Long)exchange.getIn().getBody(Long.class);
        exchange.getOut().setBody((Object)this.atomicnumber.getAndAdd(delta));
    }

    private void set(Exchange exchange) {
        this.atomicnumber.set((Long)exchange.getIn().getBody(Long.class));
    }

    private void destroy() {
        this.atomicnumber.destroy();
    }
}

