/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.instance;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.net.InetSocketAddress;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;

public class HazelcastInstanceConsumer
extends DefaultConsumer {
    public HazelcastInstanceConsumer(HazelcastInstance hazelcastInstance, DefaultEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        hazelcastInstance.getCluster().addMembershipListener(new HazelcastMembershipListener());
    }

    class HazelcastMembershipListener
    implements MembershipListener {
        HazelcastMembershipListener() {
        }

        @Override
        public void memberAdded(MembershipEvent event) {
            this.sendExchange(event, "added");
        }

        @Override
        public void memberRemoved(MembershipEvent event) {
            this.sendExchange(event, "removed");
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent event) {
            this.sendExchange(event, "updated");
        }

        private void sendExchange(MembershipEvent event, String action) {
            Exchange exchange = HazelcastInstanceConsumer.this.getEndpoint().createExchange();
            HazelcastComponentHelper.setListenerHeaders(exchange, "instancelistener", action);
            InetSocketAddress adr = event.getMember().getSocketAddress();
            if (adr != null) {
                exchange.getIn().setHeader("CamelHazelcastInstanceHost", (Object)adr.getHostName());
                exchange.getIn().setHeader("CamelHazelcastInstancePort", (Object)adr.getPort());
            }
            try {
                HazelcastInstanceConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                HazelcastInstanceConsumer.this.getExceptionHandler().handleException("Error processing exchange for Hazelcast consumer on your Hazelcast cluster.", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

