/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.nio.ClientPlainChannelInitializer;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientManagedContext;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.spi.impl.ClientProxyFactoryWithContext;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.DefaultNearCacheManager;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.memory.DefaultMemoryStats;
import com.hazelcast.memory.MemoryStats;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.function.Supplier;

public class DefaultClientExtension
implements ClientExtension {
    protected static final ILogger LOGGER = Logger.getLogger(ClientExtension.class);
    protected volatile HazelcastClientInstanceImpl client;
    private final MemoryStats memoryStats = new DefaultMemoryStats();

    @Override
    public void beforeStart(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public void afterStart(HazelcastClientInstanceImpl client) {
    }

    @Override
    public InternalSerializationService createSerializationService(byte version) {
        try {
            ClientConfig config = this.client.getClientConfig();
            ClassLoader configClassLoader = config.getClassLoader();
            HazelcastClientInstanceImpl hazelcastInstance = this.client;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            if (version > 0) {
                builder.setVersion(version);
            }
            return (InternalSerializationService)builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(new HazelcastClientManagedContext(this.client, config.getManagedContext())).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).setNotActiveExceptionSupplier(new Supplier<RuntimeException>(){

                @Override
                public RuntimeException get() {
                    return new HazelcastClientNotActiveException("Client is shutdown");
                }
            }).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = GroupProperty.PARTITIONING_STRATEGY_CLASS.getSystemProperty();
        if (partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance(configClassLoader, partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public SocketInterceptor createSocketInterceptor() {
        LOGGER.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public ChannelInitializer createChannelInitializer() {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        SSLConfig sslConfig = networkConfig.getSSLConfig();
        if (sslConfig != null && sslConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("SSL/TLS requires Hazelcast Enterprise Edition");
        }
        SocketOptions socketOptions = networkConfig.getSocketOptions();
        HazelcastProperties properties = this.client.getProperties();
        boolean directBuffer = properties.getBoolean(GroupProperty.SOCKET_CLIENT_BUFFER_DIRECT);
        return new ClientPlainChannelInitializer(socketOptions, directBuffer);
    }

    @Override
    public <T> ClientProxyFactory createServiceProxyFactory(Class<T> service) {
        if (MapService.class.isAssignableFrom(service)) {
            return this.createClientMapProxyFactory();
        }
        throw new IllegalArgumentException("Proxy factory cannot be created. Unknown service: " + service);
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    private ClientProxyFactory createClientMapProxyFactory() {
        return new ClientProxyFactoryWithContext(){

            @Override
            public ClientProxy create(String id, ClientContext context) {
                ClientConfig clientConfig = DefaultClientExtension.this.client.getClientConfig();
                NearCacheConfig nearCacheConfig = clientConfig.getNearCacheConfig(id);
                if (nearCacheConfig != null) {
                    ConfigValidator.checkNearCacheConfig(id, nearCacheConfig, clientConfig.getNativeMemoryConfig(), true);
                    return new NearCachedClientMapProxy("hz:impl:mapService", id, context);
                }
                return new ClientMapProxy("hz:impl:mapService", id, context);
            }
        };
    }

    @Override
    public NearCacheManager createNearCacheManager() {
        SerializationService ss = this.client.getSerializationService();
        ClientExecutionService es = this.client.getClientExecutionService();
        ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
        HazelcastProperties properties = this.client.getProperties();
        return new DefaultNearCacheManager(ss, es, classLoader, properties);
    }
}

