/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.SqlPredicate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.HazelcastOperation;
import org.apache.camel.component.hazelcast.map.HazelcastMapEndpoint;
import org.apache.camel.util.ObjectHelper;

public class HazelcastMapProducer
extends HazelcastDefaultProducer {
    private final IMap<Object, Object> cache;

    public HazelcastMapProducer(HazelcastInstance hazelcastInstance, HazelcastMapEndpoint endpoint, String cacheName) {
        super(endpoint);
        this.cache = hazelcastInstance.getMap(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        Object oid = null;
        Object ovalue = null;
        Object ttl = null;
        Object ttlUnit = null;
        String query = null;
        if (headers.containsKey("CamelHazelcastObjectId")) {
            oid = headers.get("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastObjectValue")) {
            ovalue = headers.get("CamelHazelcastObjectValue");
        }
        if (headers.containsKey("CamelHazelcastObjectTtlValue")) {
            ttl = headers.get("CamelHazelcastObjectTtlValue");
        }
        if (headers.containsKey("CamelHazelcastObjectTtlUnit")) {
            ttlUnit = headers.get("CamelHazelcastObjectTtlUnit");
        }
        if (headers.containsKey("CamelHazelcastQuery")) {
            query = (String)headers.get("CamelHazelcastQuery");
        }
        HazelcastOperation operation = this.lookupOperation(exchange);
        switch (operation) {
            case PUT: {
                if (ObjectHelper.isEmpty(ttl) && ObjectHelper.isEmpty(ttlUnit)) {
                    this.put(oid, exchange);
                    break;
                }
                this.put(oid, ttl, ttlUnit, exchange);
                break;
            }
            case PUT_IF_ABSENT: {
                if (ObjectHelper.isEmpty(ttl) && ObjectHelper.isEmpty(ttlUnit)) {
                    this.putIfAbsent(oid, exchange);
                    break;
                }
                this.putIfAbsent(oid, ttl, ttlUnit, exchange);
                break;
            }
            case GET: {
                this.get(oid, exchange);
                break;
            }
            case GET_ALL: {
                this.getAll(oid, exchange);
                break;
            }
            case GET_KEYS: {
                this.getKeys(exchange);
                break;
            }
            case CONTAINS_KEY: {
                this.containsKey(oid, exchange);
                break;
            }
            case CONTAINS_VALUE: {
                this.containsValue(exchange);
                break;
            }
            case DELETE: {
                this.delete(oid);
                break;
            }
            case UPDATE: {
                if (ObjectHelper.isEmpty(ovalue)) {
                    this.update(oid, exchange);
                    break;
                }
                this.update(oid, ovalue, exchange);
                break;
            }
            case QUERY: {
                this.query(query, exchange);
                break;
            }
            case CLEAR: {
                this.clear(exchange);
                break;
            }
            case EVICT: {
                this.evict(oid);
                break;
            }
            case EVICT_ALL: {
                this.evictAll();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the MAP cache.", new Object[]{operation, "CamelHazelcastOperationType"}));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void query(String query, Exchange exchange) {
        Collection<Object> result = ObjectHelper.isNotEmpty((Object)query) ? this.cache.values(new SqlPredicate(query)) : this.cache.values();
        exchange.getOut().setBody(result);
    }

    private void update(Object oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.lock(oid);
        this.cache.replace(oid, body);
        this.cache.unlock(oid);
    }

    private void update(Object oid, Object ovalue, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.lock(oid);
        this.cache.replace(oid, ovalue, body);
        this.cache.unlock(oid);
    }

    private void delete(Object oid) {
        this.cache.remove(oid);
    }

    private void get(Object oid, Exchange exchange) {
        exchange.getOut().setBody(this.cache.get(oid));
    }

    private void getAll(Object oid, Exchange exchange) {
        exchange.getOut().setBody(this.cache.getAll((Set)oid));
    }

    private void put(Object oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.put(oid, body);
    }

    private void put(Object oid, Object ttl, Object ttlUnit, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.put(oid, body, (Long)ttl, (TimeUnit)((Object)ttlUnit));
    }

    private void putIfAbsent(Object oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.putIfAbsent(oid, body);
    }

    private void putIfAbsent(Object oid, Object ttl, Object ttlUnit, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.putIfAbsent(oid, body, (Long)ttl, (TimeUnit)((Object)ttlUnit));
    }

    private void clear(Exchange exchange) {
        this.cache.clear();
    }

    private void evict(Object oid) {
        this.cache.evict(oid);
    }

    private void evictAll() {
        this.cache.evictAll();
    }

    private void containsKey(Object oid, Exchange exchange) {
        exchange.getOut().setBody((Object)this.cache.containsKey(oid));
    }

    private void containsValue(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        exchange.getOut().setBody((Object)this.cache.containsValue(body));
    }

    private void getKeys(Exchange exchange) {
        exchange.getOut().setBody(this.cache.keySet());
    }
}

