/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.queue;

import com.hazelcast.core.HazelcastInstance;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hazelcast.HazelcastCommand;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastOperation;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueConfiguration;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueConsumer;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueProducer;
import org.apache.camel.spi.UriEndpoint;

@UriEndpoint(firstVersion="2.7.0", scheme="hazelcast-queue", title="Hazelcast Queue", syntax="hazelcast-queue:cacheName", label="cache,datagrid")
public class HazelcastQueueEndpoint
extends HazelcastDefaultEndpoint {
    private final HazelcastQueueConfiguration configuration;

    public HazelcastQueueEndpoint(HazelcastInstance hazelcastInstance, String endpointUri, Component component, String cacheName, HazelcastQueueConfiguration configuration) {
        super(hazelcastInstance, endpointUri, component, cacheName);
        this.configuration = configuration;
        this.setCommand(HazelcastCommand.queue);
        this.setDefaultOperation(HazelcastOperation.ADD);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        HazelcastQueueConsumer answer = new HazelcastQueueConsumer(this.hazelcastInstance, (Endpoint)this, processor, this.cacheName, this.configuration);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new HazelcastQueueProducer(this.hazelcastInstance, this, this.cacheName);
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "QueueConsumer", this.configuration.getPoolSize());
    }
}

