/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.ReplicaFragmentMigrationState;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationInterceptor;
import com.hazelcast.internal.partition.impl.MigrationManager;
import com.hazelcast.internal.partition.operation.BaseMigrationOperation;
import com.hazelcast.internal.partition.operation.MigrationOperation;
import com.hazelcast.internal.partition.operation.ServiceNamespacesContext;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.UrgentSystemOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class MigrationRequestOperation
extends BaseMigrationOperation {
    private int maxTotalChunkedDataInBytes;
    private boolean chunkedMigrationEnabled;
    private boolean fragmentedMigrationEnabled;
    private transient ServiceNamespacesContext namespacesContext;
    private transient Map<ServiceNamespace, Collection<ChunkSupplier>> namespaceToSuppliers = new HashMap<ServiceNamespace, Collection<ChunkSupplier>>();

    public MigrationRequestOperation() {
    }

    public MigrationRequestOperation(MigrationInfo migrationInfo, List<MigrationInfo> completedMigrations, int partitionStateVersion, boolean fragmentedMigrationEnabled, boolean chunkedMigrationEnabled, int maxTotalChunkedDataInBytes) {
        super(migrationInfo, completedMigrations, partitionStateVersion);
        this.fragmentedMigrationEnabled = fragmentedMigrationEnabled;
        this.chunkedMigrationEnabled = chunkedMigrationEnabled;
        this.maxTotalChunkedDataInBytes = maxTotalChunkedDataInBytes;
    }

    @Override
    public CallStatus call() throws Exception {
        this.setActiveMigration();
        return new OffloadImpl();
    }

    @Override
    void executeBeforeMigrations() throws Exception {
        boolean ownerMigration;
        NodeEngine nodeEngine = this.getNodeEngine();
        PartitionReplica source = this.migrationInfo.getSource();
        boolean bl = ownerMigration = source != null && source.isIdentical(nodeEngine.getLocalMember());
        if (!ownerMigration) {
            return;
        }
        super.executeBeforeMigrations();
    }

    private void invokeMigrationOperation(ReplicaFragmentMigrationState migrationState, boolean firstFragment) {
        assert (ThreadUtil.isRunningOnPartitionThread()) : "Migration operations must be invoked from a partition thread";
        boolean lastFragment = !this.namespacesContext.hasNext();
        MigrationOperation operation = new MigrationOperation(this.migrationInfo, firstFragment ? this.completedMigrations : Collections.emptyList(), this.partitionStateVersion, migrationState, firstFragment, lastFragment);
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            Set namespaces = migrationState != null ? migrationState.getNamespaceVersionMap().keySet() : Collections.emptySet();
            logger.finest("Invoking MigrationOperation for namespaces " + namespaces + " and " + this.migrationInfo + ", firstFragment: " + firstFragment + ", lastFragment: " + lastFragment);
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ManagedExecutorService asyncExecutor = this.getNodeEngine().getExecutionService().getExecutor("hz:async");
        Address target = this.migrationInfo.getDestinationAddress();
        nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, target).setResultDeserialized(true).setCallTimeout(partitionService.getPartitionMigrationTimeout()).invoke().whenCompleteAsync((BiConsumer)new MigrationCallback(), (Executor)asyncExecutor);
    }

    private void trySendNewFragment() {
        try {
            this.verifyMaster();
            this.verifyExistingDestination();
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            MigrationManager migrationManager = partitionService.getMigrationManager();
            MigrationInfo currentActiveMigration = migrationManager.addActiveMigration(this.migrationInfo);
            if (!this.migrationInfo.equals(currentActiveMigration)) {
                throw new IllegalStateException("Current active migration " + currentActiveMigration + " is different than expected: " + this.migrationInfo);
            }
            ReplicaFragmentMigrationState migrationState = this.createNextReplicaFragmentMigrationState();
            if (migrationState != null) {
                this.getNodeEngine().getOperationService().execute(new InvokeMigrationOps(migrationState, this.getPartitionId()));
            } else {
                this.getLogger().finest("All migration fragments done for " + this.migrationInfo);
                this.completeMigration(true);
            }
        }
        catch (Throwable e) {
            this.logThrowable(e);
            this.completeMigration(false);
        }
    }

    private ReplicaFragmentMigrationState initialReplicaFragmentMigrationState() {
        return this.createReplicaFragmentMigrationState(Collections.emptySet(), Collections.emptySet(), Collections.emptyList(), this.maxTotalChunkedDataInBytes);
    }

    private ReplicaFragmentMigrationState createNextReplicaFragmentMigrationState() {
        Collection<ChunkSupplier> chunkSuppliers;
        ReplicaFragmentMigrationState nextChunkedState;
        if (this.chunkedMigrationEnabled && (nextChunkedState = this.createNextChunkedState()) != null) {
            return nextChunkedState;
        }
        if (!this.namespacesContext.hasNext()) {
            return null;
        }
        if (!this.fragmentedMigrationEnabled) {
            while (this.namespacesContext.hasNext()) {
                this.namespacesContext.next();
            }
            return this.createAllReplicaFragmentsMigrationState();
        }
        ServiceNamespace namespace = this.namespacesContext.next();
        if (namespace.equals(NonFragmentedServiceNamespace.INSTANCE)) {
            return this.createNonFragmentedReplicaFragmentMigrationState();
        }
        if (this.chunkedMigrationEnabled && CollectionUtil.isNotEmpty(chunkSuppliers = this.createChunkSuppliersOf(namespace))) {
            return this.createChunkedReplicaState(namespace, chunkSuppliers);
        }
        return this.createReplicaFragmentMigrationStateFor(namespace);
    }

    private Collection<ChunkSupplier> createChunkSuppliersOf(ServiceNamespace namespace) {
        return this.namespaceToSuppliers.computeIfAbsent(namespace, ns -> {
            Collection<String> serviceNames = this.namespacesContext.getServiceNames((ServiceNamespace)ns);
            return this.collectChunkSuppliers(this.getPartitionReplicationEvent(), serviceNames, (ServiceNamespace)ns);
        });
    }

    @Nullable
    private ReplicaFragmentMigrationState createNextChunkedState() {
        ServiceNamespace currentNS = this.namespacesContext.current();
        if (currentNS == null) {
            return null;
        }
        Collection<ChunkSupplier> chunkSuppliers = this.namespaceToSuppliers.get(currentNS);
        if (chunkSuppliers == null) {
            return null;
        }
        Iterator<ChunkSupplier> iterator = chunkSuppliers.iterator();
        while (iterator.hasNext()) {
            ChunkSupplier chunkSupplier = iterator.next();
            if (chunkSupplier.hasNext()) continue;
            iterator.remove();
        }
        if (CollectionUtil.isEmpty(chunkSuppliers)) {
            this.namespaceToSuppliers.remove(currentNS);
            return null;
        }
        return this.createReplicaFragmentMigrationState(Collections.singleton(currentNS), Collections.emptyList(), chunkSuppliers, this.maxTotalChunkedDataInBytes);
    }

    private ReplicaFragmentMigrationState createReplicaFragmentMigrationStateFor(ServiceNamespace ns) {
        PartitionReplicationEvent event = this.getPartitionReplicationEvent();
        Collection<String> serviceNames = this.namespacesContext.getServiceNames(ns);
        Collection<Operation> operations = this.createFragmentReplicationOperationsOffload(event, ns, serviceNames);
        return this.createReplicaFragmentMigrationState(Collections.singleton(ns), operations, Collections.emptyList(), this.maxTotalChunkedDataInBytes);
    }

    private ReplicaFragmentMigrationState createNonFragmentedReplicaFragmentMigrationState() {
        PartitionReplicationEvent event = this.getPartitionReplicationEvent();
        Collection<Operation> operations = this.createNonFragmentedReplicationOperations(event);
        Set<ServiceNamespace> namespaces = Collections.singleton(NonFragmentedServiceNamespace.INSTANCE);
        return this.createReplicaFragmentMigrationState(namespaces, operations, Collections.emptyList(), this.maxTotalChunkedDataInBytes);
    }

    private ReplicaFragmentMigrationState createChunkedReplicaState(ServiceNamespace ns, Collection<ChunkSupplier> suppliers) {
        return this.createReplicaFragmentMigrationState(Collections.singleton(ns), Collections.emptyList(), suppliers, this.maxTotalChunkedDataInBytes);
    }

    private ReplicaFragmentMigrationState createAllReplicaFragmentsMigrationState() {
        PartitionReplicationEvent event = this.getPartitionReplicationEvent();
        Collection<Operation> operations = this.createAllReplicationOperations(event);
        return this.createReplicaFragmentMigrationState(this.namespacesContext.getAllNamespaces(), operations, Collections.emptyList(), this.maxTotalChunkedDataInBytes);
    }

    private ReplicaFragmentMigrationState createReplicaFragmentMigrationState(Collection<ServiceNamespace> namespaces, Collection<Operation> operations, Collection<ChunkSupplier> suppliers, int maxTotalChunkedDataInBytes) {
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        PartitionReplicaVersionManager versionManager = partitionService.getPartitionReplicaVersionManager();
        HashMap<ServiceNamespace, long[]> versions = new HashMap<ServiceNamespace, long[]>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            long[] v = versionManager.getPartitionReplicaVersionsForSync(this.getPartitionId(), namespace);
            versions.put(namespace, v);
        }
        return new ReplicaFragmentMigrationState(versions, operations, suppliers, this.chunkedMigrationEnabled, maxTotalChunkedDataInBytes, this.getLogger(), this.getPartitionId());
    }

    @Override
    protected PartitionMigrationEvent getMigrationEvent() {
        return new PartitionMigrationEvent(MigrationEndpoint.SOURCE, this.migrationInfo.getPartitionId(), this.migrationInfo.getSourceCurrentReplicaIndex(), this.migrationInfo.getSourceNewReplicaIndex(), this.migrationInfo.getUid());
    }

    @Override
    protected MigrationInterceptor.MigrationParticipant getMigrationParticipantType() {
        return MigrationInterceptor.MigrationParticipant.SOURCE;
    }

    private PartitionReplicationEvent getPartitionReplicationEvent() {
        return new PartitionReplicationEvent(this.migrationInfo.getDestinationAddress(), this.migrationInfo.getPartitionId(), this.migrationInfo.getDestinationNewReplicaIndex());
    }

    private void completeMigration(boolean result) {
        this.success = result;
        this.onMigrationComplete();
        this.sendResponse(result);
    }

    private void logThrowable(Throwable t) {
        Throwable throwableToLog = t;
        if (throwableToLog instanceof ExecutionException) {
            throwableToLog = throwableToLog.getCause() != null ? throwableToLog.getCause() : throwableToLog;
        }
        Level level = this.getLogLevel(throwableToLog);
        this.getLogger().log(level, "Failure while executing " + this.migrationInfo, throwableToLog);
    }

    private Level getLogLevel(Throwable e) {
        return e instanceof MemberLeftException || e instanceof InterruptedException || !this.getNodeEngine().isRunning() ? Level.INFO : Level.WARNING;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.fragmentedMigrationEnabled);
        out.writeBoolean(this.chunkedMigrationEnabled);
        out.writeInt(this.maxTotalChunkedDataInBytes);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.fragmentedMigrationEnabled = in.readBoolean();
        this.chunkedMigrationEnabled = in.readBoolean();
        this.maxTotalChunkedDataInBytes = in.readInt();
    }

    private final class MigrationCallback
    implements BiConsumer<Object, Throwable> {
        private MigrationCallback() {
        }

        @Override
        public void accept(Object result, Throwable throwable) {
            if (throwable != null) {
                MigrationRequestOperation.this.logThrowable(throwable);
                MigrationRequestOperation.this.completeMigration(false);
            } else if (Boolean.TRUE.equals(result)) {
                MigrationRequestOperation.this.getNodeEngine().getExecutionService().submit("hz:async", () -> MigrationRequestOperation.this.trySendNewFragment());
            } else {
                ILogger logger = MigrationRequestOperation.this.getLogger();
                if (logger.isFineEnabled()) {
                    logger.fine("Received false response from migration destination -> " + MigrationRequestOperation.this.migrationInfo);
                }
                MigrationRequestOperation.this.completeMigration(false);
            }
        }
    }

    private final class InvokeMigrationOps
    implements PartitionSpecificRunnable,
    UrgentSystemOperation {
        private final ReplicaFragmentMigrationState migrationState;
        private final int partitionId;

        InvokeMigrationOps(ReplicaFragmentMigrationState migrationState, int partitionId) {
            this.migrationState = migrationState;
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public void run() {
            try {
                MigrationRequestOperation.this.invokeMigrationOperation(this.migrationState, false);
            }
            catch (Throwable t) {
                MigrationRequestOperation.this.logThrowable(t);
                MigrationRequestOperation.this.completeMigration(false);
            }
        }
    }

    private final class OffloadImpl
    extends Offload {
        private OffloadImpl() {
            super(MigrationRequestOperation.this);
        }

        @Override
        public void start() {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)MigrationRequestOperation.this.getNodeEngine();
            try {
                MigrationRequestOperation.this.executeBeforeMigrations();
                MigrationRequestOperation.this.namespacesContext = new ServiceNamespacesContext(nodeEngine, MigrationRequestOperation.this.getPartitionReplicationEvent());
                MigrationRequestOperation.this.invokeMigrationOperation(MigrationRequestOperation.this.initialReplicaFragmentMigrationState(), true);
            }
            catch (Throwable e) {
                MigrationRequestOperation.this.logThrowable(e);
                MigrationRequestOperation.this.completeMigration(false);
            }
        }
    }
}

