/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.PutOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.recordstore.RecordStore;
import java.util.UUID;

public enum TxnSetOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            Data dataKey = state.getKey();
            long threadId = state.getThreadId();
            long version = state.getVersion();
            UUID ownerUuid = state.getOwnerUuid();
            long callId = state.getOperation().getCallId();
            recordStore.unlock(dataKey, ownerUuid, threadId, callId);
            Object record = recordStore.getRecordOrNull(dataKey);
            if (record == null || version == (long)record.getVersion()) {
                PutOpSteps.READ.runStep(state);
                state.setEntryEventType(record == null ? EntryEventType.ADDED : EntryEventType.UPDATED);
            }
        }

        @Override
        public Step nextStep(State state) {
            return PutOpSteps.READ.nextStep(state);
        }
    };

}

