/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps.engine;

import com.hazelcast.core.Offloadable;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.operation.ForcedEviction;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import java.util.function.Supplier;

public class StepSupplier
implements Supplier<Runnable> {
    private final State state;
    private final OperationRunnerImpl operationRunner;
    private volatile Runnable currentRunnable;
    private volatile Step currentStep;
    private volatile boolean firstStep = true;
    private final boolean checkCurrentThread;

    public StepSupplier(MapOperation operation) {
        this(operation, true);
    }

    public StepSupplier(MapOperation operation, boolean checkCurrentThread) {
        assert (operation != null);
        this.state = operation.createState();
        this.currentStep = operation.getStartingStep();
        this.operationRunner = UtilSteps.getPartitionOperationRunner(this.state);
        this.checkCurrentThread = checkCurrentThread;
        assert (this.state != null);
        assert (this.currentStep != null);
    }

    @Override
    public Runnable get() {
        if (this.currentRunnable == null && this.currentStep != null) {
            this.currentRunnable = this.createRunnable(this.currentStep, this.state);
        }
        return this.currentRunnable;
    }

    private Runnable createRunnable(final Step step, final State state) {
        if (step == null) {
            return null;
        }
        if (step.isOffloadStep(state)) {
            return new ExecutorNameAwareRunnable(){

                @Override
                public String getExecutorName() {
                    return step.getExecutorName(state);
                }

                @Override
                public void run() {
                    if (StepSupplier.this.checkCurrentThread) assert (!ThreadUtil.isRunningOnPartitionThread());
                    StepSupplier.this.runStepWithState(step, state);
                }

                public String toString() {
                    return step.toString();
                }
            };
        }
        return new PartitionSpecificRunnable(){

            @Override
            public void run() {
                if (StepSupplier.this.checkCurrentThread) assert (ThreadUtil.isRunningOnPartitionThread());
                StepSupplier.this.runStepWithState(step, state);
            }

            @Override
            public int getPartitionId() {
                return state.getPartitionId();
            }

            public String toString() {
                return step.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStepWithState(Step step, State state) {
        boolean metWithPreconditions;
        boolean runningOnPartitionThread;
        block13: {
            runningOnPartitionThread = ThreadUtil.isRunningOnPartitionThread();
            metWithPreconditions = true;
            StepSupplier.log(step, state);
            if (!runningOnPartitionThread || state.getThrowable() != null || !this.firstStep || (metWithPreconditions = this.operationRunner.metWithPreconditions(state.getOperation()))) break block13;
            if (metWithPreconditions) {
                this.currentStep = this.nextStep(step);
                this.currentRunnable = this.createRunnable(this.currentStep, state);
            } else {
                this.currentStep = null;
                this.currentRunnable = null;
            }
            return;
        }
        try {
            try {
                step.runStep(state);
            }
            catch (NativeOutOfMemoryError e) {
                ThreadUtil.assertRunningOnPartitionThread();
                this.rerunWithForcedEviction(() -> step.runStep(state));
            }
        }
        catch (Throwable throwable) {
            if (runningOnPartitionThread) {
                state.getOperation().disposeDeferredBlocks();
            }
            state.setThrowable(throwable);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (metWithPreconditions) {
                this.currentStep = this.nextStep(step);
                this.currentRunnable = this.createRunnable(this.currentStep, state);
            } else {
                this.currentStep = null;
                this.currentRunnable = null;
            }
        }
    }

    private Step nextStep(Step step) {
        this.firstStep = false;
        if (this.state.getThrowable() != null && this.currentStep != UtilSteps.HANDLE_ERROR) {
            return UtilSteps.HANDLE_ERROR;
        }
        return step.nextStep(this.state);
    }

    private void rerunWithForcedEviction(Runnable step) {
        ForcedEviction.runStepWithForcedEvictionStrategies(this.state.getOperation(), step);
    }

    private static void log(Step currentStep, State state) {
        MapOperation operation = state.getOperation();
        ILogger logger = operation.getNodeEngine().getLogger(operation.getClass());
        if (logger.isFinestEnabled()) {
            logger.finest(currentStep.toString() + " ==> " + operation.hashCode());
        }
    }

    public void handleOperationError(Throwable throwable) {
        this.state.setThrowable(throwable);
        UtilSteps.HANDLE_ERROR.runStep(this.state);
    }

    private static interface ExecutorNameAwareRunnable
    extends Runnable,
    Offloadable {
    }
}

