/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;

public class HazelcastIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private String repositoryName;
    private IMap<String, Boolean> repo;
    private HazelcastInstance hazelcastInstance;

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance) {
        this(hazelcastInstance, HazelcastIdempotentRepository.class.getSimpleName());
    }

    public HazelcastIdempotentRepository(HazelcastInstance hazelcastInstance, String repositoryName) {
        this.repositoryName = repositoryName;
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    protected void doStart() throws Exception {
        this.repo = this.hazelcastInstance.getMap(this.repositoryName);
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public boolean add(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.putIfAbsent(key, false) == null;
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public boolean confirm(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.replace(key, false, true);
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public boolean contains(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.containsKey(key);
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public boolean remove(String key) {
        this.repo.lock(key);
        try {
            boolean bl = this.repo.remove(key) != null;
            return bl;
        }
        finally {
            this.repo.unlock(key);
        }
    }

    @Override
    public void clear() {
        this.repo.clear();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }
}

