/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlSummaryCodec;
import com.hazelcast.jet.impl.JobAndSqlSummary;
import com.hazelcast.jet.impl.SqlSummary;

public final class JobAndSqlSummaryCodec {
    private static final int LIGHT_JOB_FIELD_OFFSET = 0;
    private static final int JOB_ID_FIELD_OFFSET = 1;
    private static final int EXECUTION_ID_FIELD_OFFSET = 9;
    private static final int STATUS_FIELD_OFFSET = 17;
    private static final int SUBMISSION_TIME_FIELD_OFFSET = 21;
    private static final int COMPLETION_TIME_FIELD_OFFSET = 29;
    private static final int INITIAL_FRAME_SIZE = 37;

    private JobAndSqlSummaryCodec() {
    }

    public static void encode(ClientMessage clientMessage, JobAndSqlSummary jobAndSqlSummary) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[37]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, jobAndSqlSummary.isLightJob());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 1, jobAndSqlSummary.getJobId());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 9, jobAndSqlSummary.getExecutionId());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 17, jobAndSqlSummary.getStatus());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 21, jobAndSqlSummary.getSubmissionTime());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 29, jobAndSqlSummary.getCompletionTime());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, jobAndSqlSummary.getNameOrId());
        CodecUtil.encodeNullable(clientMessage, jobAndSqlSummary.getFailureText(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, jobAndSqlSummary.getSqlSummary(), SqlSummaryCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static JobAndSqlSummary decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean lightJob = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        long jobId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 1);
        long executionId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 9);
        int status = FixedSizeTypesCodec.decodeInt(initialFrame.content, 17);
        long submissionTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 21);
        long completionTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 29);
        String nameOrId = StringCodec.decode(iterator);
        String failureText = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        SqlSummary sqlSummary = CodecUtil.decodeNullable(iterator, SqlSummaryCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createJobAndSqlSummary(lightJob, jobId, executionId, nameOrId, status, submissionTime, completionTime, failureText, sqlSummary);
    }
}

