/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps.engine;

import com.hazelcast.core.Offloadable;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.engine.StepSupplier;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class StepRunner
extends Offload
implements PartitionSpecificRunnable {
    public static final ThreadLocal<Boolean> CURRENTLY_EXECUTING_ON_PARTITION_THREAD = ThreadLocal.withInitial(() -> false);
    private static final long DEFAULT_MAX_SUCCESSIVE_OFFLOADED_OP_RUN_NANOS = 0L;
    private static final String PROP_MAX_SUCCESSIVE_OFFLOADED_OP_RUN_NANOS = "hazelcast.internal.map.mapstore.max.successive.offloaded.operation.run.nanos";
    private static final HazelcastProperty MAX_SUCCESSIVE_OFFLOADED_OP_RUN_NANOS = new HazelcastProperty("hazelcast.internal.map.mapstore.max.successive.offloaded.operation.run.nanos", 0L, TimeUnit.NANOSECONDS);
    private final int partitionId;
    private final long maxRunNanos;
    private final Set<MapOperation> offloadedOperations;
    private final OperationExecutor operationExecutor;
    private final ExecutionService executionService;
    private volatile StepSupplier stepSupplier;
    private String currentExecutorName;

    public StepRunner(MapOperation mapOperation) {
        super(mapOperation);
        this.offloadedOperations = this.getOffloadedOperations(mapOperation);
        this.partitionId = mapOperation.getPartitionId();
        NodeEngine nodeEngine = mapOperation.getNodeEngine();
        this.operationExecutor = ((OperationServiceImpl)nodeEngine.getOperationService()).getOperationExecutor();
        this.executionService = nodeEngine.getExecutionService();
        this.maxRunNanos = nodeEngine.getProperties().getNanos(MAX_SUCCESSIVE_OFFLOADED_OP_RUN_NANOS);
    }

    @Override
    public void start() throws Exception {
        Operation op = this.offloadedOperation();
        this.addOpToOffloadedOps((MapOperation)op);
        if (this.isHeadOp()) {
            this.run();
        }
    }

    public static boolean isStepRunnerCurrentlyExecutingOnPartitionThread() {
        return CURRENTLY_EXECUTING_ON_PARTITION_THREAD.get();
    }

    private void addOpToOffloadedOps(MapOperation op) {
        op.setOperationResponseHandler(new OffloadedStepResponseHandler(op.getOperationResponseHandler()));
        this.offloadedOperations.add(op);
        op.getRecordStore().incMapStoreOffloadedOperationsCount();
    }

    private boolean isHeadOp() {
        return this.offloadedOperations.size() == 1;
    }

    @Override
    public void run() {
        boolean runningOnPartitionThread = ThreadUtil.isRunningOnPartitionThread();
        this.run0(runningOnPartitionThread);
    }

    private void run0(boolean runningOnPartitionThread) {
        long start = System.nanoTime();
        while (true) {
            try {
                Runnable step;
                while (true) {
                    if (this.stepSupplier == null || (step = this.stepSupplier.get()) == null) {
                        if (runningOnPartitionThread) {
                            this.stepSupplier = this.getNextStepSupplierOrNull();
                            if (this.stepSupplier != null) continue;
                            return;
                        }
                        this.operationExecutor.execute(this);
                        return;
                    }
                    if (!this.runDirect(step)) {
                        this.offloadRun(step, this);
                        return;
                    }
                    if (this.maxRunNanos > 0L && runningOnPartitionThread && System.nanoTime() - start >= this.maxRunNanos && (step = this.stepSupplier.get()) != null) break;
                }
                this.offloadRun(step, this);
                return;
            }
            catch (Throwable throwable) {
                this.stepSupplier.handleOperationError(throwable);
                continue;
            }
            break;
        }
    }

    @Nullable
    private StepSupplier getNextStepSupplierOrNull() {
        Iterator<MapOperation> iterator = this.offloadedOperations.iterator();
        if (iterator.hasNext()) {
            MapOperation operation = iterator.next();
            return new StepSupplier(operation);
        }
        return null;
    }

    private boolean runDirect(Runnable step) {
        if (step instanceof PartitionSpecificRunnable) {
            if (ThreadUtil.isRunningOnPartitionThread()) {
                try {
                    CURRENTLY_EXECUTING_ON_PARTITION_THREAD.set(true);
                    step.run();
                }
                finally {
                    CURRENTLY_EXECUTING_ON_PARTITION_THREAD.set(false);
                }
                return true;
            }
        } else if (!ThreadUtil.isRunningOnPartitionThread() && (this.currentExecutorName == null || ((Offloadable)((Object)step)).getExecutorName().equals(this.currentExecutorName))) {
            step.run();
            return true;
        }
        return false;
    }

    private void offloadRun(Runnable step, PartitionSpecificRunnable offload) {
        if (step instanceof PartitionSpecificRunnable) {
            this.operationExecutor.execute(offload);
        } else {
            Offloadable offloadableStep = (Offloadable)((Object)step);
            this.currentExecutorName = offloadableStep.getExecutorName();
            this.executionService.getExecutor(this.currentExecutorName).execute(offload);
        }
    }

    private Set<MapOperation> getOffloadedOperations(MapOperation mapOperation) {
        return mapOperation.getRecordStore().getOffloadedOperations();
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    private class OffloadedStepResponseHandler
    implements OperationResponseHandler {
        private OperationResponseHandler delegate;

        OffloadedStepResponseHandler(OperationResponseHandler delegate) {
            this.delegate = delegate;
        }

        public void sendResponse(Operation op, Object response) {
            ThreadUtil.assertRunningOnPartitionThread();
            if (StepRunner.this.offloadedOperations.remove(op)) {
                ((MapOperation)op).getRecordStore().decMapStoreOffloadedOperationsCount();
                this.delegate.sendResponse(op, response);
            }
        }
    }
}

