/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import java.util.Date;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastOperation;
import org.apache.camel.util.ObjectHelper;

public final class HazelcastComponentHelper {
    private HazelcastComponentHelper() {
    }

    public static void copyHeaders(Exchange ex) {
        Map<String, Object> headers = ex.getIn().getHeaders();
        if (headers.containsKey("CamelHazelcastObjectId")) {
            headers.remove("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastOperationType")) {
            headers.remove("CamelHazelcastOperationType");
        }
        if (ex.getMessage() != null) {
            ex.getMessage().setHeaders(headers);
        }
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction, String cacheName) {
        ex.getIn().setHeader("CamelHazelcastCacheName", cacheName);
        HazelcastComponentHelper.setListenerHeaders(ex, listenerType, listenerAction);
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction) {
        ex.getIn().setHeader("CamelHazelcastListenerAction", listenerAction);
        ex.getIn().setHeader("CamelHazelcastListenerType", listenerType);
        ex.getIn().setHeader("CamelHazelcastListenerTime", new Date().getTime());
    }

    public static HazelcastOperation lookupOperation(Exchange exchange, HazelcastOperation defaultOperation) {
        String operationName = exchange.getIn().getHeader("CamelHazelcastOperationType", String.class);
        return ObjectHelper.isEmpty(operationName) ? defaultOperation : HazelcastOperation.getHazelcastOperation(operationName);
    }
}

