/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.topic;

import com.hazelcast.core.HazelcastInstance;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hazelcast.HazelcastCommand;
import org.apache.camel.component.hazelcast.HazelcastConstants;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastOperation;
import org.apache.camel.component.hazelcast.topic.HazelcastTopicConfiguration;
import org.apache.camel.component.hazelcast.topic.HazelcastTopicConsumer;
import org.apache.camel.component.hazelcast.topic.HazelcastTopicProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="2.15.0", scheme="hazelcast-topic", title="Hazelcast Topic", syntax="hazelcast-topic:cacheName", category={Category.CACHE, Category.DATAGRID}, headersClass=HazelcastConstants.class)
public class HazelcastTopicEndpoint
extends HazelcastDefaultEndpoint
implements MultipleConsumersSupport {
    @UriParam
    private final HazelcastTopicConfiguration configuration;

    public HazelcastTopicEndpoint(HazelcastInstance hazelcastInstance, String endpointUri, Component component, String cacheName, HazelcastTopicConfiguration configuration) {
        super(hazelcastInstance, endpointUri, component, cacheName);
        this.configuration = configuration;
        this.setCommand(HazelcastCommand.topic);
        this.setDefaultOperation(HazelcastOperation.PUBLISH);
    }

    public HazelcastTopicConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        HazelcastTopicConsumer answer = new HazelcastTopicConsumer(this.hazelcastInstance, this, processor, this.cacheName, this.configuration.isReliable());
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new HazelcastTopicProducer(this.hazelcastInstance, this, this.cacheName, this.configuration.isReliable());
    }

    @Override
    public boolean isMultipleConsumersSupported() {
        return true;
    }
}

