/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.map;

import com.hazelcast.core.HazelcastInstance;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hazelcast.HazelcastCommand;
import org.apache.camel.component.hazelcast.HazelcastConstants;
import org.apache.camel.component.hazelcast.HazelcastDefaultComponent;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.map.HazelcastMapConsumer;
import org.apache.camel.component.hazelcast.map.HazelcastMapProducer;
import org.apache.camel.spi.UriEndpoint;

@UriEndpoint(firstVersion="2.7.0", scheme="hazelcast-map", title="Hazelcast Map", syntax="hazelcast-map:cacheName", category={Category.CACHE, Category.DATAGRID}, headersClass=HazelcastConstants.class)
public class HazelcastMapEndpoint
extends HazelcastDefaultEndpoint {
    public HazelcastMapEndpoint(HazelcastInstance hazelcastInstance, String uri, String cacheName, HazelcastDefaultComponent component) {
        super(hazelcastInstance, uri, component, cacheName);
        this.setCommand(HazelcastCommand.map);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        HazelcastMapConsumer answer = new HazelcastMapConsumer(this.hazelcastInstance, this, processor, this.cacheName);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new HazelcastMapProducer(this.hazelcastInstance, this, this.cacheName);
    }
}

