/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ByteRangeInputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenRenewer;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.KerberosUgiAuthenticator;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.ConcatSourcesParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.util.Progressable;
import org.mortbay.util.ajax.JSON;

public class WebHdfsFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable {
    public static final Log LOG = LogFactory.getLog(WebHdfsFileSystem.class);
    public static final String SCHEME = "webhdfs";
    public static final int VERSION = 1;
    public static final String PATH_PREFIX = "/webhdfs/v1";
    private static final KerberosUgiAuthenticator AUTH = new KerberosUgiAuthenticator();
    public static final Text TOKEN_KIND = new Text("WEBHDFS delegation");
    public static final AbstractDelegationTokenSelector<DelegationTokenIdentifier> DT_SELECTOR = new AbstractDelegationTokenSelector<DelegationTokenIdentifier>(TOKEN_KIND){};
    private static DelegationTokenRenewer<WebHdfsFileSystem> DT_RENEWER = null;
    private final UserGroupInformation ugi;
    private InetSocketAddress nnAddr;
    private Token<?> delegationToken;
    private final AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
    private RetryPolicy retryPolicy = null;
    private Path workingDir;
    private static final String OFFSET_PARAM_PREFIX = "offset=";

    public WebHdfsFileSystem() {
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized void addRenewAction(WebHdfsFileSystem webhdfs) {
        if (DT_RENEWER == null) {
            DT_RENEWER = new DelegationTokenRenewer<WebHdfsFileSystem>(WebHdfsFileSystem.class);
            DT_RENEWER.start();
        }
        DT_RENEWER.addRenewAction(webhdfs);
    }

    public static boolean isEnabled(Configuration conf, Log log) {
        boolean b = conf.getBoolean("dfs.webhdfs.enabled", false);
        log.info((Object)("dfs.webhdfs.enabled = " + b));
        return b;
    }

    @Override
    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        this.nnAddr = NetUtils.createSocketAddr(uri.getAuthority(), this.getDefaultPort());
        this.retryPolicy = RetryUtils.getDefaultRetryPolicy(conf, "dfs.client.retry.policy.enabled", false, "dfs.client.retry.policy.spec", "10000,6,60000,10", SafeModeException.class);
        this.workingDir = this.getHomeDirectory();
        if (UserGroupInformation.isSecurityEnabled()) {
            this.initDelegationToken();
        }
    }

    protected void initDelegationToken() throws IOException {
        Text serviceName = SecurityUtil.buildTokenService(this.nnAddr);
        Token<DelegationTokenIdentifier> token = DT_SELECTOR.selectToken(serviceName, this.ugi.getTokens());
        if (token == null) {
            token = DelegationTokenSelector.selectHdfsDelegationToken(this.nnAddr, this.ugi, this.getConf());
        }
        boolean createdToken = false;
        if (token == null) {
            token = this.getDelegationToken(null);
            boolean bl = createdToken = token != null;
        }
        if (token != null) {
            this.setDelegationToken(token);
            if (createdToken) {
                WebHdfsFileSystem.addRenewAction(this);
                LOG.debug((Object)("Created new DT for " + token.getService()));
            } else {
                LOG.debug((Object)("Found existing DT for " + token.getService()));
            }
        }
    }

    @Override
    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    @Override
    public URI getUri() {
        try {
            return new URI(SCHEME, null, this.nnAddr.getHostName(), this.nnAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String getHomeDirectoryString(UserGroupInformation ugi) {
        return "/user/" + ugi.getShortUserName();
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path(WebHdfsFileSystem.getHomeDirectoryString(this.ugi)));
    }

    @Override
    public synchronized Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public synchronized void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    private Path makeAbsolute(Path f) {
        return f.isAbsolute() ? f : new Path(this.workingDir, f);
    }

    static Map<?, ?> jsonParse(HttpURLConnection c, boolean useErrorStream) throws IOException {
        MediaType parsed;
        InputStream in;
        if (c.getContentLength() == 0) {
            return null;
        }
        InputStream inputStream = in = useErrorStream ? c.getErrorStream() : c.getInputStream();
        if (in == null) {
            throw new IOException("The " + (useErrorStream ? "error" : "input") + " stream is null.");
        }
        String contentType = c.getContentType();
        if (contentType != null && !MediaType.APPLICATION_JSON_TYPE.isCompatible(parsed = MediaType.valueOf(contentType))) {
            throw new IOException("Content-Type \"" + contentType + "\" is incompatible with \"" + "application/json" + "\" (parsed=\"" + parsed + "\")");
        }
        return (Map)JSON.parse(new InputStreamReader(in));
    }

    private static Map<?, ?> validateResponse(HttpOpParam.Op op, HttpURLConnection conn, boolean unwrapException) throws IOException {
        int code = conn.getResponseCode();
        if (code != op.getExpectedHttpResponseCode()) {
            Map<?, ?> m;
            try {
                m = WebHdfsFileSystem.jsonParse(conn, true);
            }
            catch (Exception e) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage(), e);
            }
            if (m == null) {
                throw new IOException("Unexpected HTTP response: code=" + code + " != " + op.getExpectedHttpResponseCode() + ", " + op.toQueryString() + ", message=" + conn.getResponseMessage());
            }
            if (m.get(RemoteException.class.getSimpleName()) == null) {
                return m;
            }
            RemoteException re = JsonUtil.toRemoteException(m);
            throw unwrapException ? WebHdfsFileSystem.toIOException(re) : re;
        }
        return null;
    }

    private static IOException toIOException(Exception e) {
        if (!(e instanceof IOException)) {
            return new IOException(e);
        }
        IOException ioe = (IOException)e;
        if (!(ioe instanceof RemoteException)) {
            return ioe;
        }
        RemoteException re = (RemoteException)ioe;
        return re.unwrapRemoteException(AccessControlException.class, SecretManager.InvalidToken.class, AuthenticationException.class, AuthorizationException.class, FileAlreadyExistsException.class, FileNotFoundException.class, SafeModeException.class, DSQuotaExceededException.class, NSQuotaExceededException.class);
    }

    private URL getNamenodeURL(String path, String query) throws IOException {
        URL url = new URL("http", this.nnAddr.getHostName(), this.nnAddr.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addDt2Query(String query) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            WebHdfsFileSystem webHdfsFileSystem = this;
            synchronized (webHdfsFileSystem) {
                if (this.delegationToken != null) {
                    String encoded = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam(encoded);
                }
            }
        }
        return query;
    }

    URL toUrl(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        String path = PATH_PREFIX + (fspath == null ? "/" : this.makeQualified(fspath).toUri().getPath());
        String query = op.toQueryString() + '&' + new UserParam(this.ugi) + Param.toSortedString("&", parameters);
        URL url = op.equals(PutOpParam.Op.RENEWDELEGATIONTOKEN) || op.equals(GetOpParam.Op.GETDELEGATIONTOKEN) ? this.getNamenodeURL(path, query) : this.getNamenodeURL(path, this.addDt2Query(query));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    private HttpURLConnection getHttpUrlConnection(URL url) throws IOException, AuthenticationException {
        HttpURLConnection conn = this.ugi.hasKerberosCredentials() ? new AuthenticatedURL(AUTH).openConnection(url, this.authToken) : (HttpURLConnection)url.openConnection();
        return conn;
    }

    private Map<?, ?> run(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
        return new Runner(op, fspath, parameters).run().json;
    }

    private FsPermission applyUMask(FsPermission permission) {
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        return permission.applyUMask(FsPermission.getUMask(this.getConf()));
    }

    private HdfsFileStatus getHdfsFileStatus(Path f) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETFILESTATUS;
        Map<?, ?> json = this.run(op, f, new Param[0]);
        HdfsFileStatus status = JsonUtil.toFileStatus(json, true);
        if (status == null) {
            throw new FileNotFoundException("File does not exist: " + f);
        }
        return status;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.makeQualified(this.getHdfsFileStatus(f), f);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.getFullPath(parent).makeQualified(this));
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.MKDIRS;
        Map<?, ?> json = this.run(op, f, new PermissionParam(this.applyUMask(permission)));
        return (Boolean)json.get("boolean");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.RENAME;
        Map<?, ?> json = this.run(op, src, new DestinationParam(this.makeQualified(dst).toUri().getPath()));
        return (Boolean)json.get("boolean");
    }

    @Override
    public void setOwner(Path p, String owner, String group) throws IOException {
        if (owner == null && group == null) {
            throw new IOException("owner == null && group == null");
        }
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETOWNER;
        this.run(op, p, new OwnerParam(owner), new GroupParam(group));
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETPERMISSION;
        this.run(op, p, new PermissionParam(permission));
    }

    @Override
    public boolean setReplication(Path p, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETREPLICATION;
        Map<?, ?> json = this.run(op, p, new ReplicationParam(replication));
        return (Boolean)json.get("boolean");
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.SETTIMES;
        this.run(op, p, new ModificationTimeParam(mtime), new AccessTimeParam(atime));
    }

    @Override
    public long getDefaultBlockSize() {
        return this.getConf().getLong("dfs.block.size", 0x4000000L);
    }

    @Override
    public short getDefaultReplication() {
        return (short)this.getConf().getInt("dfs.replication", 3);
    }

    FSDataOutputStream write(final HttpOpParam.Op op, final HttpURLConnection conn, int bufferSize) throws IOException {
        return new FSDataOutputStream(new BufferedOutputStream(conn.getOutputStream(), bufferSize), this.statistics){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    try {
                        WebHdfsFileSystem.validateResponse(op, conn, true);
                    }
                    finally {
                        conn.disconnect();
                    }
                }
            }
        };
    }

    @Override
    public void concat(Path trg, Path[] srcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.CONCAT;
        ConcatSourcesParam param = new ConcatSourcesParam(srcs);
        this.run(op, trg, param);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PutOpParam.Op op = PutOpParam.Op.CREATE;
        return new Runner((HttpOpParam.Op)op, f, new PermissionParam(this.applyUMask(permission)), new OverwriteParam(overwrite), new BufferSizeParam(bufferSize), new ReplicationParam(replication), new BlockSizeParam(blockSize)).run().write(bufferSize);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        PostOpParam.Op op = PostOpParam.Op.APPEND;
        return new Runner((HttpOpParam.Op)op, f, new BufferSizeParam(bufferSize)).run().write(bufferSize);
    }

    @Override
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        DeleteOpParam.Op op = DeleteOpParam.Op.DELETE;
        Map<?, ?> json = this.run(op, f, new RecursiveParam(recursive));
        return (Boolean)json.get("boolean");
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.OPEN;
        URL url = this.toUrl(op, f, new BufferSizeParam(buffersize));
        return new FSDataInputStream(new OffsetUrlInputStream(new OffsetUrlOpener(url), new OffsetUrlOpener(null)));
    }

    static URL removeOffsetParam(URL url) throws MalformedURLException {
        String query = url.getQuery();
        if (query == null) {
            return url;
        }
        String lower = query.toLowerCase();
        if (!lower.startsWith(OFFSET_PARAM_PREFIX) && !lower.contains("&offset=")) {
            return url;
        }
        StringBuilder b = null;
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.toLowerCase().startsWith(OFFSET_PARAM_PREFIX)) continue;
            if (b == null) {
                b = new StringBuilder("?").append(token);
                continue;
            }
            b.append('&').append(token);
        }
        query = b == null ? "" : b.toString();
        String urlStr = url.toString();
        return new URL(urlStr.substring(0, urlStr.indexOf(63)) + query);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.LISTSTATUS;
        Map<?, ?> json = this.run(op, f, new Param[0]);
        Map rootmap = (Map)json.get(FileStatus.class.getSimpleName() + "es");
        Object[] array = (Object[])rootmap.get(FileStatus.class.getSimpleName());
        FileStatus[] statuses = new FileStatus[array.length];
        for (int i = 0; i < array.length; ++i) {
            Map m = (Map)array[i];
            statuses[i] = this.makeQualified(JsonUtil.toFileStatus(m, false), f);
        }
        return statuses;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        GetOpParam.Op op = GetOpParam.Op.GETDELEGATIONTOKEN;
        Map<?, ?> m = this.run(op, null, new RenewerParam(renewer));
        Token<DelegationTokenIdentifier> token = JsonUtil.toDelegationToken(m);
        SecurityUtil.setTokenService(token, this.nnAddr);
        return token;
    }

    @Override
    public Token<?> getRenewToken() {
        return this.delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        WebHdfsFileSystem webHdfsFileSystem = this;
        synchronized (webHdfsFileSystem) {
            this.delegationToken = token;
        }
    }

    private synchronized long renewDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.RENEWDELEGATIONTOKEN;
        TokenArgumentParam dtargParam = new TokenArgumentParam(token.encodeToUrlString());
        Map<?, ?> m = this.run(op, null, dtargParam);
        return (Long)m.get("long");
    }

    private synchronized void cancelDelegationToken(Token<?> token) throws IOException {
        PutOpParam.Op op = PutOpParam.Op.CANCELDELEGATIONTOKEN;
        TokenArgumentParam dtargParam = new TokenArgumentParam(token.encodeToUrlString());
        this.run(op, null, dtargParam);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus status, long offset, long length) throws IOException {
        if (status == null) {
            return null;
        }
        this.statistics.incrementReadOps(1);
        Path p = status.getPath();
        GetOpParam.Op op = GetOpParam.Op.GET_BLOCK_LOCATIONS;
        Map<?, ?> m = this.run(op, p, new OffsetParam(offset), new LengthParam(length));
        return DFSUtil.locatedBlocks2Locations(JsonUtil.toLocatedBlocks(m));
    }

    @Override
    public ContentSummary getContentSummary(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETCONTENTSUMMARY;
        Map<?, ?> m = this.run(op, p, new Param[0]);
        return JsonUtil.toContentSummary(m);
    }

    @Override
    public MD5MD5CRC32FileChecksum getFileChecksum(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        GetOpParam.Op op = GetOpParam.Op.GETFILECHECKSUM;
        Map<?, ?> m = this.run(op, p, new Param[0]);
        return JsonUtil.toMD5MD5CRC32FileChecksum(m);
    }

    public static class DtRenewer
    extends TokenRenewer {
        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(TOKEN_KIND);
        }

        @Override
        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        private static WebHdfsFileSystem getWebHdfs(Token<?> token, Configuration conf) throws IOException {
            InetSocketAddress nnAddr = SecurityUtil.getTokenServiceAddr(token);
            URI uri = DFSUtil.createUri(WebHdfsFileSystem.SCHEME, nnAddr);
            return (WebHdfsFileSystem)FileSystem.get(uri, conf);
        }

        @Override
        public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.checkTGTAndReloginFromKeytab();
            return DtRenewer.getWebHdfs(token, conf).renewDelegationToken(token);
        }

        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.checkTGTAndReloginFromKeytab();
            DtRenewer.getWebHdfs(token, conf).cancelDelegationToken(token);
        }
    }

    static class OffsetUrlInputStream
    extends ByteRangeInputStream {
        OffsetUrlInputStream(OffsetUrlOpener o, OffsetUrlOpener r) {
            super(o, r);
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) throws MalformedURLException {
            return WebHdfsFileSystem.removeOffsetParam(connection.getURL());
        }
    }

    class OffsetUrlOpener
    extends ByteRangeInputStream.URLOpener {
        OffsetUrlOpener(URL url) {
            super(url);
        }

        @Override
        protected HttpURLConnection connect(long offset, boolean resolved) throws IOException {
            URL offsetUrl = offset == 0L ? this.url : new URL(this.url + "&" + new OffsetParam(offset));
            return new Runner((HttpOpParam.Op)GetOpParam.Op.OPEN, offsetUrl, resolved).run().conn;
        }
    }

    class Runner {
        private final HttpOpParam.Op op;
        private final URL url;
        private final boolean redirected;
        private boolean checkRetry;
        private HttpURLConnection conn = null;
        private Map<?, ?> json = null;

        Runner(HttpOpParam.Op op, URL url, boolean redirected) {
            this.op = op;
            this.url = url;
            this.redirected = redirected;
        }

        Runner(HttpOpParam.Op op, Path fspath, Param<?, ?> ... parameters) throws IOException {
            this(op, webHdfsFileSystem.toUrl(op, fspath, parameters), false);
        }

        Runner(HttpOpParam.Op op, HttpURLConnection conn) {
            this(op, null, false);
            this.conn = conn;
        }

        private void init() throws IOException {
            this.checkRetry = !this.redirected;
            try {
                this.conn = WebHdfsFileSystem.this.getHttpUrlConnection(this.url);
            }
            catch (AuthenticationException ae) {
                this.checkRetry = false;
                throw new IOException("Authentication failed, url=" + this.url, ae);
            }
        }

        private void connect() throws IOException {
            this.connect(this.op.getDoOutput());
        }

        private void connect(boolean doOutput) throws IOException {
            this.conn.setRequestMethod(this.op.getType().toString());
            this.conn.setDoOutput(doOutput);
            this.conn.setInstanceFollowRedirects(false);
            this.conn.connect();
        }

        private void disconnect() {
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }

        Runner run() throws IOException {
            int retry = 0;
            while (true) {
                try {
                    this.init();
                    if (this.op.getDoOutput()) {
                        this.twoStepWrite();
                    } else {
                        this.getResponse(this.op != GetOpParam.Op.OPEN);
                    }
                    return this;
                }
                catch (IOException ioe) {
                    this.shouldRetry(ioe, retry);
                    ++retry;
                    continue;
                }
                break;
            }
        }

        private void shouldRetry(IOException ioe, int retry) throws IOException {
            if (this.checkRetry) {
                try {
                    if (WebHdfsFileSystem.this.retryPolicy.shouldRetry(ioe, retry)) {
                        LOG.info((Object)("Retrying connect to namenode: " + WebHdfsFileSystem.this.nnAddr + ". Already tried " + retry + " time(s); retry policy is " + WebHdfsFileSystem.this.retryPolicy));
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Original exception is ", (Throwable)ioe);
                    throw WebHdfsFileSystem.toIOException(e);
                }
            }
            throw WebHdfsFileSystem.toIOException(ioe);
        }

        HttpURLConnection twoStepWrite() throws IOException {
            this.connect(false);
            WebHdfsFileSystem.validateResponse(HttpOpParam.TemporaryRedirectOp.valueOf(this.op), this.conn, false);
            String redirect = this.conn.getHeaderField("Location");
            this.disconnect();
            this.checkRetry = false;
            this.conn = (HttpURLConnection)new URL(redirect).openConnection();
            this.conn.setRequestProperty("Content-Type", "application/octet-stream");
            this.conn.setChunkedStreamingMode(32768);
            this.connect();
            return this.conn;
        }

        FSDataOutputStream write(int bufferSize) throws IOException {
            return WebHdfsFileSystem.this.write(this.op, this.conn, bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getResponse(boolean getJsonAndDisconnect) throws IOException {
            try {
                this.connect();
                int code = this.conn.getResponseCode();
                if (!this.redirected && this.op.getRedirect() && code != this.op.getExpectedHttpResponseCode()) {
                    String redirect = this.conn.getHeaderField("Location");
                    this.json = WebHdfsFileSystem.validateResponse(HttpOpParam.TemporaryRedirectOp.valueOf(this.op), this.conn, false);
                    this.disconnect();
                    this.checkRetry = false;
                    this.conn = (HttpURLConnection)new URL(redirect).openConnection();
                    this.connect();
                }
                this.json = WebHdfsFileSystem.validateResponse(this.op, this.conn, false);
                if (this.json == null && getJsonAndDisconnect) {
                    this.json = WebHdfsFileSystem.jsonParse(this.conn, false);
                }
            }
            finally {
                if (getJsonAndDisconnect) {
                    this.disconnect();
                }
            }
        }
    }
}

