/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.util.NativeCodeLoader;

public class NativeIO {
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_EXCL = 128;
    public static final int O_NOCTTY = 256;
    public static final int O_TRUNC = 512;
    public static final int O_APPEND = 1024;
    public static final int O_NONBLOCK = 2048;
    public static final int O_SYNC = 4096;
    public static final int O_ASYNC = 8192;
    public static final int O_FSYNC = 4096;
    public static final int O_NDELAY = 2048;
    public static final int POSIX_FADV_NORMAL = 0;
    public static final int POSIX_FADV_RANDOM = 1;
    public static final int POSIX_FADV_SEQUENTIAL = 2;
    public static final int POSIX_FADV_WILLNEED = 3;
    public static final int POSIX_FADV_DONTNEED = 4;
    public static final int POSIX_FADV_NOREUSE = 5;
    public static final int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
    public static final int SYNC_FILE_RANGE_WRITE = 2;
    public static final int SYNC_FILE_RANGE_WAIT_AFTER = 4;
    private static final Log LOG = LogFactory.getLog(NativeIO.class);
    private static boolean nativeLoaded = false;
    private static boolean fadvisePossible = true;
    private static boolean syncFileRangePossible = true;
    private static final Map<Long, CachedUid> uidCache;
    private static long cacheTimeout;
    private static boolean initialized;

    public static boolean isAvailable() {
        return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
    }

    public static native FileDescriptor open(String var0, int var1, int var2) throws IOException;

    public static native Stat fstat(FileDescriptor var0) throws IOException;

    private static native long getUIDforFDOwnerforOwner(FileDescriptor var0) throws IOException;

    private static native String getUserName(long var0) throws IOException;

    private static native void initNative();

    public static native void chmod(String var0, int var1) throws IOException;

    static native void posix_fadvise(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

    static native void sync_file_range(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

    public static void posixFadviseIfPossible(FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
        if (nativeLoaded && fadvisePossible) {
            try {
                NativeIO.posix_fadvise(fd, offset, len, flags);
            }
            catch (UnsupportedOperationException uoe) {
                fadvisePossible = false;
            }
            catch (UnsatisfiedLinkError ule) {
                fadvisePossible = false;
            }
        }
    }

    public static void syncFileRangeIfPossible(FileDescriptor fd, long offset, long nbytes, int flags) throws NativeIOException {
        if (nativeLoaded && syncFileRangePossible) {
            try {
                NativeIO.sync_file_range(fd, offset, nbytes, flags);
            }
            catch (UnsupportedOperationException uoe) {
                syncFileRangePossible = false;
            }
            catch (UnsatisfiedLinkError ule) {
                syncFileRangePossible = false;
            }
        }
    }

    public static String getOwner(FileDescriptor fd) throws IOException {
        NativeIO.ensureInitialized();
        long uid = NativeIO.getUIDforFDOwnerforOwner(fd);
        CachedUid cUid = uidCache.get(uid);
        long now = System.currentTimeMillis();
        if (cUid != null && cUid.timestamp + cacheTimeout > now) {
            return cUid.username;
        }
        String user = NativeIO.getUserName(uid);
        LOG.info((Object)("Got UserName " + user + " for UID " + uid + " from the native implementation"));
        cUid = new CachedUid(user, now);
        uidCache.put(uid, cUid);
        return user;
    }

    private static synchronized void ensureInitialized() {
        if (!initialized) {
            cacheTimeout = new Configuration().getLong("hadoop.security.uid.cache.secs", 14400L) * 1000L;
            LOG.info((Object)("Initialized cache for UID to User mapping with a cache timeout of " + cacheTimeout / 1000L + " seconds."));
            initialized = true;
        }
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                NativeIO.initNative();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                LOG.error((Object)"Unable to initialize NativeIO libraries", t);
            }
        }
        uidCache = new ConcurrentHashMap<Long, CachedUid>();
        initialized = false;
    }

    public static class Stat {
        private String owner;
        private int mode;
        public static final int S_IFMT = 61440;
        public static final int S_IFIFO = 4096;
        public static final int S_IFCHR = 8192;
        public static final int S_IFDIR = 16384;
        public static final int S_IFBLK = 24576;
        public static final int S_IFREG = 32768;
        public static final int S_IFLNK = 40960;
        public static final int S_IFSOCK = 49152;
        public static final int S_IFWHT = 57344;
        public static final int S_ISUID = 2048;
        public static final int S_ISGID = 1024;
        public static final int S_ISVTX = 512;
        public static final int S_IRUSR = 256;
        public static final int S_IWUSR = 128;
        public static final int S_IXUSR = 64;

        Stat(String owner, int mode) {
            this.owner = owner;
            this.mode = mode;
        }

        public String toString() {
            return "Stat(owner='" + this.owner + "'" + ", mode=" + this.mode + ")";
        }

        public String getOwner() {
            return this.owner;
        }

        public int getMode() {
            return this.mode;
        }
    }

    private static class CachedUid {
        final long timestamp;
        final String username;

        public CachedUid(String username, long timestamp) {
            this.timestamp = timestamp;
            this.username = username;
        }
    }
}

