/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.util.ServletUtil;

public class LogLevel {
    public static final String USAGES = "\nUSAGES:\njava " + LogLevel.class.getName() + " -getlevel <host:port> <name>\n" + "java " + LogLevel.class.getName() + " -setlevel <host:port> <name> <level>\n";
    static final String MARKER = "<!-- OUTPUT -->";
    static final Pattern TAG = Pattern.compile("<[^>]*>");

    public static void main(String[] args) {
        if (args.length == 3 && "-getlevel".equals(args[0])) {
            LogLevel.process("http://" + args[1] + "/logLevel?log=" + args[2]);
            return;
        }
        if (args.length == 4 && "-setlevel".equals(args[0])) {
            LogLevel.process("http://" + args[1] + "/logLevel?log=" + args[2] + "&level=" + args[3]);
            return;
        }
        System.err.println(USAGES);
        System.exit(-1);
    }

    private static void process(String urlstring) {
        try {
            String line;
            URL url = new URL(urlstring);
            System.out.println("Connecting to " + url);
            URLConnection connection = url.openConnection();
            connection.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (!line.startsWith(MARKER)) continue;
                System.out.println(TAG.matcher(line).replaceAll(""));
            }
            in.close();
        }
        catch (IOException ioe) {
            System.err.println("" + ioe);
        }
    }

    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        static final String FORMS = "\n<br /><hr /><h3>Get / Set</h3>\n<form>Log: <input type='text' size='50' name='log' /> <input type='submit' value='Get Log Level' /></form>\n<form>Log: <input type='text' size='50' name='log' /> Level: <input type='text' name='level' /> <input type='submit' value='Set Log Level' /></form>";

        @Override
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer.hasAdministratorAccess(this.getServletContext(), request, response)) {
                return;
            }
            PrintWriter out = ServletUtil.initHTML(response, "Log Level");
            String logName = ServletUtil.getParameter(request, "log");
            String level = ServletUtil.getParameter(request, "level");
            if (logName != null) {
                out.println("<br /><hr /><h3>Results</h3>");
                out.println("<!-- OUTPUT -->Submitted Log Name: <b>" + logName + "</b><br />");
                Log log = LogFactory.getLog((String)logName);
                out.println("<!-- OUTPUT -->Log Class: <b>" + log.getClass().getName() + "</b><br />");
                if (level != null) {
                    out.println("<!-- OUTPUT -->Submitted Level: <b>" + level + "</b><br />");
                }
                if (log instanceof Log4JLogger) {
                    Servlet.process(((Log4JLogger)log).getLogger(), level, out);
                } else if (log instanceof Jdk14Logger) {
                    Servlet.process(((Jdk14Logger)log).getLogger(), level, out);
                } else {
                    out.println("Sorry, " + log.getClass() + " not supported.<br />");
                }
            }
            out.println(FORMS);
            out.println(ServletUtil.HTML_TAIL);
        }

        private static void process(org.apache.log4j.Logger log, String level, PrintWriter out) throws IOException {
            if (level != null) {
                log.setLevel(org.apache.log4j.Level.toLevel((String)level));
                out.println("<!-- OUTPUT -->Setting Level to " + level + " ...<br />");
            }
            out.println("<!-- OUTPUT -->Effective level: <b>" + log.getEffectiveLevel() + "</b><br />");
        }

        private static void process(Logger log, String level, PrintWriter out) throws IOException {
            Level lev;
            if (level != null) {
                log.setLevel(Level.parse(level));
                out.println("<!-- OUTPUT -->Setting Level to " + level + " ...<br />");
            }
            while ((lev = log.getLevel()) == null) {
                log = log.getParent();
            }
            out.println("<!-- OUTPUT -->Effective level: <b>" + lev + "</b><br />");
        }
    }
}

