/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.util.VersionInfo;
import org.znerd.xmlenc.XMLOutputter;

public class ListPathsServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;
    public static final ThreadLocal<SimpleDateFormat> df = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return HftpFileSystem.getDateFormat();
        }
    };

    static void writeInfo(Path fullpath, HdfsFileStatus i, XMLOutputter doc) throws IOException {
        SimpleDateFormat ldf = df.get();
        doc.startTag(i.isDir() ? "directory" : "file");
        doc.attribute("path", fullpath.toUri().getPath());
        doc.attribute("modified", ldf.format(new Date(i.getModificationTime())));
        doc.attribute("accesstime", ldf.format(new Date(i.getAccessTime())));
        if (!i.isDir()) {
            doc.attribute("size", String.valueOf(i.getLen()));
            doc.attribute("replication", String.valueOf(i.getReplication()));
            doc.attribute("blocksize", String.valueOf(i.getBlockSize()));
        }
        doc.attribute("permission", (i.isDir() ? "d" : "-") + i.getPermission());
        doc.attribute("owner", i.getOwner());
        doc.attribute("group", i.getGroup());
        doc.endTag();
    }

    protected Map<String, String> buildRoot(HttpServletRequest request, XMLOutputter doc) {
        String path = request.getPathInfo() != null ? request.getPathInfo() : "/";
        String exclude = request.getParameter("exclude") != null ? request.getParameter("exclude") : "";
        String filter = request.getParameter("filter") != null ? request.getParameter("filter") : ".*";
        boolean recur = request.getParameter("recursive") != null && "yes".equals(request.getParameter("recursive"));
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("path", path);
        root.put("recursive", recur ? "yes" : "no");
        root.put("filter", filter);
        root.put("exclude", exclude);
        root.put("time", df.get().format(new Date()));
        root.put("version", VersionInfo.getVersion());
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        final XMLOutputter doc = new XMLOutputter((Writer)out, "UTF-8");
        final Map<String, String> root = this.buildRoot(request, doc);
        final String path = root.get("path");
        try {
            final boolean recur = "yes".equals(root.get("recursive"));
            final Pattern filter = Pattern.compile(root.get("filter"));
            final Pattern exclude = Pattern.compile(root.get("exclude"));
            Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            this.getUGI(request, conf).doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ClientProtocol nn = ListPathsServlet.this.createNameNodeProxy();
                    doc.declaration();
                    doc.startTag("listing");
                    for (Map.Entry m : root.entrySet()) {
                        doc.attribute((String)m.getKey(), (String)m.getValue());
                    }
                    HdfsFileStatus base = nn.getFileInfo(path);
                    if (base != null && base.isDir()) {
                        ListPathsServlet.writeInfo(base.getFullPath(new Path(path)), base, doc);
                    }
                    Stack<String> pathstack = new Stack<String>();
                    pathstack.push(path);
                    block3: while (!pathstack.empty()) {
                        String p = (String)pathstack.pop();
                        try {
                            DirectoryListing thisListing;
                            byte[] lastReturnedName = HdfsFileStatus.EMPTY_NAME;
                            do {
                                HdfsFileStatus[] listing;
                                assert (lastReturnedName != null);
                                thisListing = nn.getListing(p, lastReturnedName);
                                if (thisListing == null) {
                                    if (lastReturnedName.length != 0) continue block3;
                                    DfsServlet.LOG.warn((Object)("ListPathsServlet - Path " + p + " does not exist"));
                                    continue block3;
                                }
                                for (HdfsFileStatus i : listing = thisListing.getPartialListing()) {
                                    Path fullpath = i.getFullPath(new Path(p));
                                    String localName = fullpath.getName();
                                    if (exclude.matcher(localName).matches() || !filter.matcher(localName).matches()) continue;
                                    if (recur && i.isDir()) {
                                        pathstack.push(new Path(p, localName).toUri().getPath());
                                    }
                                    ListPathsServlet.writeInfo(fullpath, i, doc);
                                }
                                lastReturnedName = thisListing.getLastName();
                            } while (thisListing.hasMore());
                        }
                        catch (IOException re) {
                            ListPathsServlet.this.writeXml(re, p, doc);
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            this.writeXml(ioe, path, doc);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"ListPathServlet encountered InterruptedException", (Throwable)e);
            response.sendError(400, e.getMessage());
        }
        finally {
            if (doc != null) {
                doc.endDocument();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

