/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.resources;

import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.web.resources.OpenEntity;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.ParamFilter;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.UriFsPathParam;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@Path(value="")
@ResourceFilters(value={ParamFilter.class})
public class DatanodeWebHdfsMethods {
    public static final Log LOG = LogFactory.getLog(DatanodeWebHdfsMethods.class);
    private static final UriFsPathParam ROOT = new UriFsPathParam("");
    @Context
    private ServletContext context;
    @Context
    private HttpServletResponse response;

    private void init(UserGroupInformation ugi, DelegationParam delegation, UriFsPathParam path, HttpOpParam<?> op, Param<?, ?> ... parameters) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HTTP " + (Object)((Object)((HttpOpParam.Op)((Object)((Enum)op.getValue()))).getType()) + ": " + op + ", " + path + ", ugi=" + ugi + Param.toSortedString(", ", parameters)));
        }
        this.response.setContentType(null);
        if (UserGroupInformation.isSecurityEnabled()) {
            DataNode datanode = (DataNode)this.context.getAttribute("datanode");
            InetSocketAddress nnRpcAddr = NameNode.getAddress(datanode.getConf());
            Token token = new Token();
            token.decodeFromUrlString((String)delegation.getValue());
            SecurityUtil.setTokenService(token, nnRpcAddr);
            token.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
            ugi.addToken(token);
        }
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response putRoot(InputStream in, @Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize) throws IOException, InterruptedException {
        return this.put(in, ugi, delegation, ROOT, op, permission, overwrite, bufferSize, replication, blockSize);
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response put(final InputStream in, @Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, final @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, final @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, final @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, final @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize) throws IOException, InterruptedException {
        this.init(ugi, delegation, path, op, permission, overwrite, bufferSize, replication, blockSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response run() throws IOException, URISyntaxException {
                String fullpath = path.getAbsolutePath();
                DataNode datanode = (DataNode)DatanodeWebHdfsMethods.this.context.getAttribute("datanode");
                switch ((PutOpParam.Op)op.getValue()) {
                    case CREATE: {
                        Configuration conf = new Configuration(datanode.getConf());
                        conf.set("dfs.umaskmode", "000");
                        int b = bufferSize.getValue(conf);
                        DFSClient dfsclient = new DFSClient(conf);
                        FSDataOutputStream out = null;
                        try {
                            out = new FSDataOutputStream(dfsclient.create(fullpath, permission.getFsPermission(), (Boolean)overwrite.getValue(), replication.getValue(conf), blockSize.getValue(conf), null, b), null);
                            IOUtils.copyBytes(in, (OutputStream)out, b);
                            out.close();
                            out = null;
                            dfsclient.close();
                            dfsclient = null;
                        }
                        catch (Throwable throwable) {
                            IOUtils.cleanup(LOG, out);
                            IOUtils.cleanup(LOG, dfsclient);
                            throw throwable;
                        }
                        IOUtils.cleanup(LOG, out);
                        IOUtils.cleanup(LOG, dfsclient);
                        String nnAddr = NameNode.getInfoServer(conf);
                        URI uri = new URI("webhdfs://" + nnAddr + fullpath);
                        return Response.created(uri).type("application/octet-stream").build();
                    }
                }
                throw new UnsupportedOperationException(op + " is not supported");
            }
        });
    }

    @POST
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response postRoot(InputStream in, @Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        return this.post(in, ugi, delegation, ROOT, op, bufferSize);
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream", "application/json"})
    public Response post(final InputStream in, @Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        this.init(ugi, delegation, path, op, bufferSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response run() throws IOException {
                String fullpath = path.getAbsolutePath();
                DataNode datanode = (DataNode)DatanodeWebHdfsMethods.this.context.getAttribute("datanode");
                switch ((PostOpParam.Op)op.getValue()) {
                    case APPEND: {
                        Configuration conf = new Configuration(datanode.getConf());
                        int b = bufferSize.getValue(conf);
                        DFSClient dfsclient = new DFSClient(conf);
                        FSDataOutputStream out = null;
                        try {
                            out = dfsclient.append(fullpath, b, null, null);
                            IOUtils.copyBytes(in, (OutputStream)out, b);
                            out.close();
                            out = null;
                            dfsclient.close();
                            dfsclient = null;
                        }
                        catch (Throwable throwable) {
                            IOUtils.cleanup(LOG, out);
                            IOUtils.cleanup(LOG, dfsclient);
                            throw throwable;
                        }
                        IOUtils.cleanup(LOG, out);
                        IOUtils.cleanup(LOG, dfsclient);
                        return Response.ok().type("application/octet-stream").build();
                    }
                }
                throw new UnsupportedOperationException(op + " is not supported");
            }
        });
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response getRoot(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        return this.get(ugi, delegation, ROOT, op, offset, length, bufferSize);
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response get(@Context UserGroupInformation ugi, @QueryParam(value="delegation") @DefaultValue(value="") DelegationParam delegation, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, final @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, final @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, InterruptedException {
        this.init(ugi, delegation, path, op, offset, length, bufferSize);
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response run() throws IOException {
                String fullpath = path.getAbsolutePath();
                DataNode datanode = (DataNode)DatanodeWebHdfsMethods.this.context.getAttribute("datanode");
                Configuration conf = new Configuration(datanode.getConf());
                InetSocketAddress nnRpcAddr = NameNode.getAddress(conf);
                switch ((GetOpParam.Op)op.getValue()) {
                    case OPEN: {
                        int b = bufferSize.getValue(conf);
                        DFSClient dfsclient = new DFSClient(nnRpcAddr, conf);
                        DFSClient.DFSDataInputStream in = null;
                        try {
                            in = new DFSClient.DFSDataInputStream(dfsclient.open(fullpath, b, true, null));
                            in.seek((Long)offset.getValue());
                        }
                        catch (IOException ioe) {
                            IOUtils.cleanup(LOG, in);
                            IOUtils.cleanup(LOG, dfsclient);
                            throw ioe;
                        }
                        long n = length.getValue() != null ? ((Long)length.getValue()).longValue() : in.getVisibleLength();
                        return Response.ok(new OpenEntity(in, n, dfsclient)).type("application/octet-stream").build();
                    }
                    case GETFILECHECKSUM: {
                        MD5MD5CRC32FileChecksum checksum = null;
                        DFSClient dfsclient = new DFSClient(nnRpcAddr, conf);
                        try {
                            checksum = dfsclient.getFileChecksum(fullpath);
                            dfsclient.close();
                            dfsclient = null;
                        }
                        catch (Throwable throwable) {
                            IOUtils.cleanup(LOG, dfsclient);
                            throw throwable;
                        }
                        IOUtils.cleanup(LOG, dfsclient);
                        String js = JsonUtil.toJsonString(checksum);
                        return Response.ok(js).type("application/json").build();
                    }
                }
                throw new UnsupportedOperationException(op + " is not supported");
            }
        });
    }
}

