/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hipchat;

import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class HipchatConfiguration {
    @UriPath
    @Metadata(required="true")
    private String protocol;
    @UriPath
    @Metadata(required="true")
    private String host = "api.hipchat.com";
    @UriPath(defaultValue="80")
    private Integer port = 80;
    @UriParam
    private String authToken;
    @UriParam
    private String consumeUsers;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getConsumeUsers() {
        return this.consumeUsers;
    }

    public void setConsumeUsers(String consumeUsers) {
        this.consumeUsers = consumeUsers;
    }

    public String hipChatUrl() {
        return this.getProtocol() + "://" + this.getHost() + ":" + this.getPort();
    }

    public String[] consumableUsers() {
        return this.consumeUsers != null ? this.consumeUsers.split(",") : new String[]{};
    }

    public String withAuthToken(String urlPath) {
        return urlPath + "?auth_token=" + this.getAuthToken();
    }
}

