/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Version {
    V21("2.1"),
    V22("2.2"),
    V23("2.3"),
    V231("2.3.1"),
    V24("2.4"),
    V25("2.5"),
    V251("2.5.1"),
    V26("2.6");

    private String version;
    private static ArrayList<Version> ourVersionsOnClasspath;
    private static final Map<Version, Boolean> ourIsOnClasspath;

    private Version(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageVersion() {
        return "v" + this.version.replace(".", "");
    }

    public static boolean supportsVersion(String theVersion) {
        return Version.versionOf(theVersion) != null;
    }

    public static Version versionOf(String version) {
        for (Version v : Version.values()) {
            if (!v.getVersion().equals(version)) continue;
            return v;
        }
        return null;
    }

    public static boolean allVersions(Set<Version> someVersions) {
        return someVersions != null && someVersions.size() == Version.values().length;
    }

    public boolean isGreaterThan(Version theVersion) {
        return this.compareTo(theVersion) > 0;
    }

    public static Version latestVersion() {
        Version[] versions = Version.values();
        if (versions.length > 0) {
            return versions[versions.length - 1];
        }
        return null;
    }

    public static Version[] asOf(Version v) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Version version : Version.values()) {
            if (version.compareTo(v) < 0) continue;
            versions.add(version);
        }
        return versions.toArray(new Version[versions.size()]);
    }

    public static Version[] except(Version v) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Version version : Version.values()) {
            if (version.compareTo(v) == 0) continue;
            versions.add(version);
        }
        return versions.toArray(new Version[versions.size()]);
    }

    public static Version[] before(Version v) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (Version version : Version.values()) {
            if (version.compareTo(v) >= 0) continue;
            versions.add(version);
        }
        return versions.toArray(new Version[versions.size()]);
    }

    public String modelPackageName() {
        return String.format("%s.model.%s.", ((Object)((Object)this)).getClass().getPackage().getName(), this.getPackageVersion());
    }

    public synchronized boolean available() {
        Boolean retVal = ourIsOnClasspath.get((Object)this);
        if (retVal == null) {
            String resource = "ca/uhn/hl7v2/parser/eventmap/" + this.getVersion() + ".properties";
            InputStream in = Parser.class.getClassLoader().getResourceAsStream(resource);
            retVal = in != null;
            ourIsOnClasspath.put(this, retVal);
        }
        return retVal;
    }

    public static synchronized List<Version> availableVersions() {
        if (ourVersionsOnClasspath == null) {
            ourVersionsOnClasspath = new ArrayList();
            for (Version next : Version.values()) {
                if (!next.available()) continue;
                ourVersionsOnClasspath.add(next);
            }
        }
        return ourVersionsOnClasspath;
    }

    public static Version lowestAvailableVersion() {
        List<Version> availableVersions = Version.availableVersions();
        if (availableVersions.size() > 0) {
            return availableVersions.get(0);
        }
        return null;
    }

    public static Version highestAvailableVersionOrDefault() {
        List<Version> availableVersions = Version.availableVersions();
        if (availableVersions.size() > 0) {
            return availableVersions.get(availableVersions.size() - 1);
        }
        return V25;
    }

    public GenericMessage newGenericMessage(ModelClassFactory mcf) {
        switch (this) {
            case V21: {
                return new GenericMessage.V21(mcf);
            }
            case V22: {
                return new GenericMessage.V22(mcf);
            }
            case V23: {
                return new GenericMessage.V23(mcf);
            }
            case V231: {
                return new GenericMessage.V231(mcf);
            }
            case V24: {
                return new GenericMessage.V24(mcf);
            }
            case V25: {
                return new GenericMessage.V25(mcf);
            }
            case V251: {
                return new GenericMessage.V251(mcf);
            }
            case V26: {
                return new GenericMessage.V26(mcf);
            }
        }
        throw new Error("Unknown version (this is a HAPI bug): " + this.getVersion());
    }

    static {
        ourIsOnClasspath = new HashMap<Version, Boolean>();
    }
}

