/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.builder.support.ChoiceElementsRespectedRule;
import ca.uhn.hl7v2.validation.builder.support.OnlyAllowableSegmentsInSuperstructureRule;
import ca.uhn.hl7v2.validation.builder.support.OnlyKnownSegmentsRule;
import ca.uhn.hl7v2.validation.builder.support.TerserMessageRule;
import ca.uhn.hl7v2.validation.builder.support.WrongVersionRule;
import ca.uhn.hl7v2.validation.impl.ConformanceProfileRule;
import ca.uhn.hl7v2.validation.impl.MessageRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRuleBuilder
extends RuleTypeBuilder<MessageRuleBuilder, MessageRule> {
    private String messageType;
    private String triggerEvent;

    protected MessageRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions, String messageType, String triggerEvent) {
        super(rules, versions);
        this.messageType = messageType;
        this.triggerEvent = triggerEvent;
    }

    public MessageRuleBuilder terser(String spec, Predicate predicate) {
        return (MessageRuleBuilder)this.test(this.prepareRule(new TerserMessageRule(spec, predicate)));
    }

    public MessageRuleBuilder onlyKnownSegments() {
        return (MessageRuleBuilder)this.test(this.prepareRule(OnlyKnownSegmentsRule.ONLY_KNOWN_SEGMENTS));
    }

    public MessageRuleBuilder onlyAllowableSegmentsInSuperStructure() {
        return (MessageRuleBuilder)this.test(this.prepareRule(OnlyAllowableSegmentsInSuperstructureRule.ONLY_ALLOWABLE_SEGMENTS));
    }

    public MessageRuleBuilder choiceElementsRespected() {
        return (MessageRuleBuilder)this.test(this.prepareRule(ChoiceElementsRespectedRule.CHOICE_ELEMENTS_RESPECTED));
    }

    public MessageRuleBuilder wrongVersion() {
        return (MessageRuleBuilder)this.test(this.prepareRule(WrongVersionRule.WRONG_VERSION));
    }

    public MessageRuleBuilder conformance() {
        return this.conformance(null);
    }

    public MessageRuleBuilder conformance(String profileId) {
        return (MessageRuleBuilder)this.test(this.prepareRule(new ConformanceProfileRule(profileId)));
    }

    String getMessageType() {
        return this.messageType;
    }

    String getTriggerEvent() {
        return this.triggerEvent;
    }

    @Override
    protected Collection<RuleBinding<MessageRule>> getRuleBindings(MessageRule rule, String version) {
        MessageRuleBinding binding = new MessageRuleBinding(version, this.messageType, this.triggerEvent, rule);
        return this.activate(Collections.singletonList(binding));
    }
}

