/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hl7.HL7Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;

public class HL7DataFormat
implements DataFormat {
    private static final Map<String, String> HEADER_MAP = new HashMap<String, String>();
    private Parser parser = new GenericParser();

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        Message message = (Message)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Message.class, (Object)body);
        String encoded = HL7Converter.encode(message, this.parser);
        String charsetName = IOHelper.getCharsetName((Exchange)exchange);
        outputStream.write(encoded.getBytes(charsetName));
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        String body = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)inputStream);
        Message message = HL7Converter.parse(body, this.parser);
        Terser terser = new Terser(message);
        for (Map.Entry<String, String> entry : HEADER_MAP.entrySet()) {
            exchange.getOut().setHeader(entry.getKey(), (Object)terser.get(entry.getValue()));
        }
        return message;
    }

    public boolean isValidate() {
        return !(this.parser.getValidationContext() instanceof NoValidation);
    }

    public void setValidate(boolean validate) {
        if (!validate) {
            this.parser.setValidationContext(new NoValidation());
        }
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    static {
        HEADER_MAP.put("CamelHL7SendingApplication", "MSH-3");
        HEADER_MAP.put("CamelHL7SendingFacility", "MSH-4");
        HEADER_MAP.put("CamelHL7ReceivingApplication", "MSH-5");
        HEADER_MAP.put("CamelHL7ReceivingFacility", "MSH-6");
        HEADER_MAP.put("CamelHL7Timestamp", "MSH-7");
        HEADER_MAP.put("CamelHL7Security", "MSH-8");
        HEADER_MAP.put("CamelHL7MessageType", "MSH-9-1");
        HEADER_MAP.put("CamelHL7TriggerEvent", "MSH-9-2");
        HEADER_MAP.put("CamelHL7MessageControl", "MSH-10");
        HEADER_MAP.put("CamelHL7ProcessingId", "MSH-11");
        HEADER_MAP.put("CamelHL7VersionId", "MSH-12");
    }
}

