/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.Message;
import java.nio.charset.CharsetEncoder;
import org.apache.camel.component.hl7.HL7Converter;
import org.apache.camel.component.hl7.HL7MLLPCodec;
import org.apache.camel.component.hl7.HL7MLLPConfig;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HL7MLLPEncoder
implements ProtocolEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(HL7MLLPEncoder.class);
    private static final String CHARSET_ENCODER = HL7MLLPCodec.class.getName() + ".charsetencoder";
    private HL7MLLPConfig config;

    HL7MLLPEncoder(HL7MLLPConfig config) {
        this.config = config;
    }

    public void dispose(IoSession session) throws Exception {
        session.removeAttribute((Object)CHARSET_ENCODER);
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        String body;
        if (message == null) {
            throw new IllegalArgumentException("Message to encode is null");
        }
        if (message instanceof Exception) {
            throw (Exception)message;
        }
        CharsetEncoder encoder = (CharsetEncoder)session.getAttribute((Object)CHARSET_ENCODER);
        if (encoder == null) {
            encoder = this.config.getCharset().newEncoder();
            session.setAttribute((Object)CHARSET_ENCODER, (Object)encoder);
        }
        if (message instanceof Message) {
            body = HL7Converter.encode((Message)message, this.config.getParser());
        } else if (message instanceof String) {
            body = (String)message;
        } else if (message instanceof byte[]) {
            body = new String((byte[])message);
        } else {
            throw new IllegalArgumentException("The message to encode is not a supported type: " + message.getClass().getCanonicalName());
        }
        if (this.config.isConvertLFtoCR()) {
            body = body.replace('\n', '\r');
        }
        IoBuffer buf = IoBuffer.allocate((int)(body.length() + 3)).setAutoExpand(true);
        buf.put((byte)this.config.getStartByte());
        buf.putString((CharSequence)body, encoder);
        buf.put((byte)this.config.getEndByte1());
        buf.put((byte)this.config.getEndByte2());
        buf.flip();
        LOG.debug("Encoding HL7 from {} to byte stream", (Object)message.getClass().getCanonicalName());
        out.write(buf);
    }
}

