/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.validation.MessageValidator;
import ca.uhn.hl7v2.validation.ValidationContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;

public class ValidationContextPredicate
implements Predicate {
    private Expression validatorExpression;

    public ValidationContextPredicate(ValidationContext validationContext) {
        this(ExpressionBuilder.constantExpression((Object)validationContext));
    }

    public ValidationContextPredicate(Expression expression) {
        this.validatorExpression = expression;
    }

    public boolean matches(Exchange exchange) {
        try {
            ValidationContext context = (ValidationContext)this.validatorExpression.evaluate(exchange, ValidationContext.class);
            MessageValidator validator = new MessageValidator(context, false);
            return (Boolean)validator.validate((Message)exchange.getIn().getBody(Message.class));
        }
        catch (HL7Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

