/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.impl.AbstractJMSTransport;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class JMSQueueTransport
extends AbstractJMSTransport {
    private QueueSession mySendingSession;
    private QueueSession myReceivingSession;
    private QueueSender mySender;
    private QueueReceiver myReceiver;
    private QueueConnection myConnection;
    private Queue myQueue;

    public JMSQueueTransport(QueueConnection theConnection, Queue theDestination) {
        this.myConnection = theConnection;
        this.myQueue = theDestination;
    }

    @Override
    protected String getDestinationName() throws JMSException {
        return this.myQueue.getQueueName();
    }

    @Override
    public Connection getConnection() {
        return this.myConnection;
    }

    @Override
    protected Message getMessage() throws JMSException {
        return this.mySendingSession.createTextMessage();
    }

    @Override
    protected void sendJMS(Message theMessage) throws JMSException {
        this.mySender.send(theMessage);
    }

    @Override
    protected Message receiveJMS() throws JMSException {
        return this.myReceiver.receive();
    }

    @Override
    public void doConnect() throws TransportException {
        boolean transacted = false;
        int ackMode = 1;
        this.doDisconnect();
        try {
            this.mySendingSession = this.myConnection.createQueueSession(transacted, ackMode);
            this.mySender = this.mySendingSession.createSender(this.myQueue);
            this.myReceivingSession = this.myConnection.createQueueSession(transacted, ackMode);
            this.myReceiver = this.myReceivingSession.createReceiver(this.myQueue);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public void doDisconnect() throws TransportException {
        try {
            if (this.mySendingSession != null) {
                this.mySendingSession.close();
            }
            if (this.myReceivingSession != null) {
                this.myReceivingSession.close();
            }
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }
}

