/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.model.AdviceWithDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.support.PatternHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdviceWithTasks {
    private static final Logger LOG = LoggerFactory.getLogger(AdviceWithTasks.class);

    private AdviceWithTasks() {
    }

    public static AdviceWithTask replaceByToString(RouteDefinition route, String toString, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask replaceByToUri(RouteDefinition route, String toUri, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask replaceById(RouteDefinition route, String id, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask replaceByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doReplace(route, matchBy, replace, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doReplace(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> replace, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                boolean match = false;
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output, route)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    ProcessorDefinition flattern = AdviceWithTasks.flatternOutput(replace);
                    outputs.add(index + 1, flattern);
                    Object old = outputs.remove(index);
                    NamedNode parent = output.getParent() != null ? output.getParent() : route;
                    flattern.setParent((ProcessorDefinition<?>)parent);
                    LOG.info("AdviceWith ({}) : [{}] --> replace [{}]", new Object[]{matchBy.getId(), old, flattern});
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask removeByToString(RouteDefinition route, String toString, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask removeByToUri(RouteDefinition route, String toUri, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask removeById(RouteDefinition route, String id, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask removeByType(RouteDefinition route, Class<?> type, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doRemove(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doRemove(final RouteDefinition route, final MatchBy matchBy, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output, route)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    Object old = outputs.remove(index);
                    LOG.info("AdviceWith ({}) : [{}] --> remove", (Object)matchBy.getId(), old);
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask beforeByToString(RouteDefinition route, String toString, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask beforeByToUri(RouteDefinition route, String toUri, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask beforeById(RouteDefinition route, String id, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask beforeByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doBefore(route, matchBy, before, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doBefore(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> before, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output, route)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    ProcessorDefinition flattern = AdviceWithTasks.flatternOutput(before);
                    Object existing = outputs.get(index);
                    outputs.add(index, flattern);
                    NamedNode parent = output.getParent() != null ? output.getParent() : route;
                    flattern.setParent((ProcessorDefinition<?>)parent);
                    LOG.info("AdviceWith ({}) : [{}] --> before [{}]", new Object[]{matchBy.getId(), existing, flattern});
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask afterByToString(RouteDefinition route, String toString, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask afterByToUri(RouteDefinition route, String toUri, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToUri matchBy = new MatchByToUri(toUri);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask afterById(RouteDefinition route, String id, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    public static AdviceWithTask afterByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        return AdviceWithTasks.doAfter(route, matchBy, after, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
    }

    private static AdviceWithTask doAfter(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> after, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo, final int maxDeep) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                Iterator it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getOutputs(output, route)) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    ProcessorDefinition flattern = AdviceWithTasks.flatternOutput(after);
                    Object existing = outputs.get(index);
                    outputs.add(index + 1, flattern);
                    NamedNode parent = output.getParent() != null ? output.getParent() : route;
                    flattern.setParent((ProcessorDefinition<?>)parent);
                    LOG.info("AdviceWith ({}) : [{}] --> after [{}]", new Object[]{matchBy.getId(), existing, flattern});
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    private static List<ProcessorDefinition<?>> getOutputs(ProcessorDefinition<?> node, RouteDefinition route) {
        if (node == null) {
            return null;
        }
        if (node instanceof InterceptDefinition) {
            return route.getOutputs();
        }
        if (node instanceof InterceptSendToEndpointDefinition) {
            return route.getOutputs();
        }
        if (node instanceof OnExceptionDefinition) {
            return route.getOutputs();
        }
        if (node instanceof OnCompletionDefinition) {
            return route.getOutputs();
        }
        NamedNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof ChoiceDefinition) {
            return node.getOutputs();
        }
        List<ProcessorDefinition<?>> outputs = ((ProcessorDefinition)parent).getOutputs();
        if (outputs.size() == 1 && outputs.get(0).isAbstract()) {
            outputs = outputs.get(0).getOutputs();
        }
        return outputs;
    }

    public static AdviceWithTask replaceFromWith(final RouteDefinition route, final String uri) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                FromDefinition from = route.getInput();
                LOG.info("AdviceWith replace input from [{}] --> [{}]", (Object)from.getEndpointUri(), (Object)uri);
                from.setEndpoint(null);
                from.setUri(uri);
            }
        };
    }

    public static AdviceWithTask replaceFrom(final RouteDefinition route, final Endpoint endpoint) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                FromDefinition from = route.getInput();
                LOG.info("AdviceWith replace input from [{}] --> [{}]", (Object)from.getEndpointUri(), (Object)endpoint.getEndpointUri());
                from.setUri(null);
                from.setEndpoint(endpoint);
            }
        };
    }

    private static Iterator<ProcessorDefinition<?>> createMatchByIterator(RouteDefinition route, MatchBy matchBy, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        ArrayList matched = new ArrayList();
        ArrayList outputs = new ArrayList();
        boolean skip = selectFirst || selectLast;
        for (ProcessorDefinition<?> output : route.getOutputs()) {
            if (output instanceof TransactedDefinition) {
                outputs.addAll(output.getOutputs());
                continue;
            }
            if (skip) {
                boolean invalid = outputs.isEmpty() && output.isAbstract();
                if (invalid) continue;
                outputs.add(output);
                continue;
            }
            outputs.add(output);
        }
        Collection<ProcessorDefinition> all = ProcessorDefinitionHelper.filterTypeInOutputs(outputs, ProcessorDefinition.class, maxDeep);
        for (ProcessorDefinition proc : all) {
            if (!matchBy.match(proc)) continue;
            matched.add(proc);
        }
        return AdviceWithTasks.createSelectorIterator(matched, selectFirst, selectLast, selectFrom, selectTo);
    }

    private static Iterator<ProcessorDefinition<?>> createSelectorIterator(final List<ProcessorDefinition<?>> list, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo) {
        return new Iterator<ProcessorDefinition<?>>(){
            private int current;
            private boolean done;

            @Override
            public boolean hasNext() {
                if (list.isEmpty() || this.done) {
                    return false;
                }
                if (selectFirst) {
                    this.done = true;
                    this.current = 0;
                    return true;
                }
                if (selectLast) {
                    this.done = true;
                    this.current = list.size() - 1;
                    return true;
                }
                if (selectFrom >= 0 && selectTo >= 0) {
                    if (selectFrom >= list.size() || selectTo >= list.size()) {
                        return false;
                    }
                    if (this.current < selectFrom) {
                        this.current = selectFrom;
                    }
                    return this.current <= selectTo;
                }
                return this.current < list.size();
            }

            @Override
            public ProcessorDefinition<?> next() {
                ProcessorDefinition answer = (ProcessorDefinition)list.get(this.current);
                ++this.current;
                return answer;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static ProcessorDefinition<?> flatternOutput(ProcessorDefinition<?> output) {
        if (output instanceof AdviceWithDefinition) {
            AdviceWithDefinition advice = (AdviceWithDefinition)output;
            if (advice.getOutputs().size() == 1) {
                return advice.getOutputs().get(0);
            }
            PipelineDefinition pipe = new PipelineDefinition();
            pipe.setOutputs(advice.getOutputs());
            return pipe;
        }
        return output;
    }

    private static final class MatchByType
    implements MatchBy {
        private final Class<?> type;

        private MatchByType(Class<?> type) {
            this.type = type;
        }

        @Override
        public String getId() {
            return this.type.getSimpleName();
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            return this.type.isAssignableFrom(processor.getClass());
        }
    }

    private static final class MatchByToUri
    implements MatchBy {
        private final String toUri;

        private MatchByToUri(String toUri) {
            this.toUri = toUri;
        }

        @Override
        public String getId() {
            return this.toUri;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            if (processor instanceof EndpointRequiredDefinition) {
                String uri = ((EndpointRequiredDefinition)((Object)processor)).getEndpointUri();
                return PatternHelper.matchPattern(uri, this.toUri);
            }
            return false;
        }
    }

    private static final class MatchByToString
    implements MatchBy {
        private final String toString;

        private MatchByToString(String toString) {
            this.toString = toString;
        }

        @Override
        public String getId() {
            return this.toString;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            return PatternHelper.matchPattern(processor.toString(), this.toString);
        }
    }

    private static final class MatchById
    implements MatchBy {
        private final String id;

        private MatchById(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            if (this.id.equals("*")) {
                return true;
            }
            return PatternHelper.matchPattern(processor.getId(), this.id);
        }
    }

    private static interface MatchBy {
        public String getId();

        public boolean match(ProcessorDefinition<?> var1);
    }
}

