/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.ExpressionAdapter;

public class AckExpression
extends ExpressionAdapter {
    private AcknowledgmentCode acknowledgementCode;
    private String errorMessage;
    private ErrorCode errorCode;

    public AckExpression() {
        this(null, null, ErrorCode.APPLICATION_INTERNAL_ERROR);
    }

    public AckExpression(AcknowledgmentCode acknowledgementCode) {
        this(acknowledgementCode, null, ErrorCode.APPLICATION_INTERNAL_ERROR);
    }

    public AckExpression(AcknowledgmentCode acknowledgementCode, String errorMessage, ErrorCode errorCode) {
        this.acknowledgementCode = acknowledgementCode;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    @Override
    public Object evaluate(Exchange exchange) {
        Throwable t = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
        Message msg = exchange.getIn().getBody(Message.class);
        try {
            HL7Exception hl7e = this.generateHL7Exception(t);
            AcknowledgmentCode code = this.acknowledgementCode;
            if (t != null && code == null) {
                code = AcknowledgmentCode.AE;
            }
            return msg.generateACK(code == null ? AcknowledgmentCode.AA : code, hl7e);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    private HL7Exception generateHL7Exception(Throwable t) {
        HL7Exception hl7Exception = null;
        if (t == null) {
            if (this.acknowledgementCode != null && !this.isSuccess(this.acknowledgementCode)) {
                hl7Exception = new HL7Exception(this.errorMessage, this.errorCode);
            }
        } else {
            hl7Exception = t instanceof HL7Exception ? (HL7Exception)t : new HL7Exception(this.errorMessage != null ? this.errorMessage : t.getMessage(), this.errorCode, t);
        }
        return hl7Exception;
    }

    private boolean isSuccess(AcknowledgmentCode code) {
        return code.name().endsWith("A");
    }
}

