/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateRouteFromTemplateException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DefaultRouteTemplateContext;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteFilters;
import org.apache.camel.model.RouteTemplateBeanDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.RouteTemplateHelper;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.Suppliers;

public class DefaultModel
implements Model {
    private final CamelContext camelContext;
    private ModelReifierFactory modelReifierFactory = new DefaultModelReifierFactory();
    private final List<ModelLifecycleStrategy> modelLifecycleStrategies = new ArrayList<ModelLifecycleStrategy>();
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private final List<RouteTemplateDefinition> routeTemplateDefinitions = new ArrayList<RouteTemplateDefinition>();
    private final List<RestDefinition> restDefinitions = new ArrayList<RestDefinition>();
    private final Map<String, RouteTemplateDefinition.Converter> routeTemplateConverters = new ConcurrentHashMap<String, RouteTemplateDefinition.Converter>();
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private List<TransformerDefinition> transformers = new ArrayList<TransformerDefinition>();
    private List<ValidatorDefinition> validators = new ArrayList<ValidatorDefinition>();
    private final Map<String, ServiceCallConfigurationDefinition> serviceCallConfigurations = new ConcurrentHashMap<String, ServiceCallConfigurationDefinition>();
    private final Map<String, HystrixConfigurationDefinition> hystrixConfigurations = new ConcurrentHashMap<String, HystrixConfigurationDefinition>();
    private final Map<String, Resilience4jConfigurationDefinition> resilience4jConfigurations = new ConcurrentHashMap<String, Resilience4jConfigurationDefinition>();
    private final Map<String, FaultToleranceConfigurationDefinition> faultToleranceConfigurations = new ConcurrentHashMap<String, FaultToleranceConfigurationDefinition>();
    private Function<RouteDefinition, Boolean> routeFilter;

    public DefaultModel(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void addModelLifecycleStrategy(ModelLifecycleStrategy modelLifecycleStrategy) {
        if (!this.modelLifecycleStrategies.contains(modelLifecycleStrategy)) {
            this.modelLifecycleStrategies.add(modelLifecycleStrategy);
        }
    }

    @Override
    public List<ModelLifecycleStrategy> getModelLifecycleStrategies() {
        return this.modelLifecycleStrategies;
    }

    @Override
    public synchronized void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        ArrayList<RouteDefinition> list;
        if (routeDefinitions == null || routeDefinitions.isEmpty()) {
            return;
        }
        if (this.routeFilter == null) {
            list = new ArrayList<RouteDefinition>(routeDefinitions);
        } else {
            list = new ArrayList();
            for (RouteDefinition r : routeDefinitions) {
                if (!this.routeFilter.apply(r).booleanValue()) continue;
                list.add(r);
            }
        }
        this.removeRouteDefinitions(list);
        for (RouteDefinition r : list) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteDefinition(r);
            }
            this.routeDefinitions.add(r);
        }
        if (this.shouldStartRoutes()) {
            this.getCamelContext().adapt(ModelCamelContext.class).startRouteDefinitions(list);
        }
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.addRouteDefinitions(Collections.singletonList(routeDefinition));
    }

    @Override
    public synchronized void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    @Override
    public synchronized void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        RouteDefinition toBeRemoved = routeDefinition;
        String id = routeDefinition.getId();
        if (id != null) {
            this.camelContext.getRouteController().stopRoute(id);
            this.camelContext.removeRoute(id);
            toBeRemoved = this.getRouteDefinition(id);
        }
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteDefinition(toBeRemoved);
        }
        this.routeDefinitions.remove(toBeRemoved);
    }

    @Override
    public synchronized List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    @Override
    public synchronized RouteDefinition getRouteDefinition(String id) {
        for (RouteDefinition route : this.routeDefinitions) {
            if (!route.idOrCreate(this.camelContext.adapt(ExtendedCamelContext.class).getNodeIdFactory()).equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public List<RouteTemplateDefinition> getRouteTemplateDefinitions() {
        return this.routeTemplateDefinitions;
    }

    @Override
    public RouteTemplateDefinition getRouteTemplateDefinition(String id) {
        for (RouteTemplateDefinition route : this.routeTemplateDefinitions) {
            if (!route.idOrCreate(this.camelContext.adapt(ExtendedCamelContext.class).getNodeIdFactory()).equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public void addRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (routeTemplateDefinitions == null || routeTemplateDefinitions.isEmpty()) {
            return;
        }
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteTemplateDefinition(r);
            }
            this.routeTemplateDefinitions.add(r);
        }
    }

    @Override
    public void addRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        this.addRouteTemplateDefinitions(Collections.singletonList(routeTemplateDefinition));
    }

    @Override
    public void removeRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            this.removeRouteTemplateDefinition(r);
        }
    }

    @Override
    public void removeRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteTemplateDefinition(routeTemplateDefinition);
        }
        this.routeTemplateDefinitions.remove(routeTemplateDefinition);
    }

    @Override
    public void addRouteTemplateDefinitionConverter(String templateIdPattern, RouteTemplateDefinition.Converter converter) {
        this.routeTemplateConverters.put(templateIdPattern, converter);
    }

    @Override
    @Deprecated
    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        DefaultRouteTemplateContext rtc = new DefaultRouteTemplateContext(this.camelContext);
        if (parameters != null) {
            parameters.forEach(rtc::setParameter);
        }
        return this.addRouteFromTemplate(routeId, routeTemplateId, rtc);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, RouteTemplateContext routeTemplateContext) throws Exception {
        String string;
        RouteTemplateDefinition target = null;
        for (RouteTemplateDefinition def2 : this.routeTemplateDefinitions) {
            if (!routeTemplateId.equals(def2.getId())) continue;
            target = def2;
            break;
        }
        if (target == null) {
            Object location = routeTemplateContext.getParameters().get("location");
            if (location != null) {
                RouteTemplateLoaderListener listener = CamelContextHelper.findByType(this.getCamelContext(), RouteTemplateLoaderListener.class);
                RouteTemplateHelper.loadRouteTemplateFromLocation(this.getCamelContext(), listener, routeTemplateId, location.toString());
            }
            for (RouteTemplateDefinition routeTemplateDefinition : this.routeTemplateDefinitions) {
                if (!routeTemplateId.equals(routeTemplateDefinition.getId())) continue;
                target = routeTemplateDefinition;
                break;
            }
        }
        if (target == null) {
            throw new IllegalArgumentException("Cannot find RouteTemplate with id " + routeTemplateId);
        }
        HashMap<String, Object> prop = new HashMap<String, Object>();
        if (target.getTemplateParameters() != null) {
            StringJoiner templatesBuilder = new StringJoiner(", ");
            for (RouteTemplateParameterDefinition routeTemplateParameterDefinition : target.getTemplateParameters()) {
                if (routeTemplateParameterDefinition.getDefaultValue() != null) {
                    prop.put(routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
                    continue;
                }
                if (!routeTemplateParameterDefinition.isRequired() || routeTemplateContext.getParameters().containsKey(routeTemplateParameterDefinition.getName())) continue;
                templatesBuilder.add(routeTemplateParameterDefinition.getName());
            }
            if (templatesBuilder.length() > 0) {
                throw new IllegalArgumentException("Route template " + routeTemplateId + " the following mandatory parameters must be provided: " + templatesBuilder);
            }
        }
        if (routeTemplateContext.getParameters() != null) {
            prop.putAll(routeTemplateContext.getParameters());
        }
        if (target.getTemplateParameters() != null) {
            for (RouteTemplateParameterDefinition routeTemplateParameterDefinition : target.getTemplateParameters()) {
                if (routeTemplateContext.getParameters().containsKey(routeTemplateParameterDefinition.getName()) || routeTemplateParameterDefinition.getDefaultValue() == null) continue;
                routeTemplateContext.setParameter(routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
            }
        }
        RouteTemplateDefinition.Converter converter = RouteTemplateDefinition.Converter.DEFAULT_CONVERTER;
        for (Map.Entry<String, RouteTemplateDefinition.Converter> entry : this.routeTemplateConverters.entrySet()) {
            String key = entry.getKey();
            String templateId = target.getId();
            if ("*".equals(key) || templateId.equals(key)) {
                converter = entry.getValue();
                break;
            }
            if (AntPathMatcher.INSTANCE.match(key, templateId)) {
                converter = entry.getValue();
                break;
            }
            if (!templateId.matches(key)) continue;
            converter = entry.getValue();
            break;
        }
        RouteDefinition routeDefinition = converter.apply(target, prop);
        if (routeId != null) {
            routeDefinition.setId(routeId);
        }
        routeDefinition.setTemplateParameters(prop);
        routeDefinition.setRouteTemplateContext(routeTemplateContext);
        if (target.getTemplateBeans() != null) {
            this.addTemplateBeans(routeTemplateContext, target);
        }
        if (target.getConfigurer() != null) {
            routeTemplateContext.setConfigurer(target.getConfigurer());
        }
        if ((string = RouteDefinitionHelper.validateUniqueIds(routeDefinition, this.routeDefinitions)) != null) {
            throw new FailedToCreateRouteFromTemplateException(routeId, routeTemplateId, "duplicate id detected: " + string + ". Please correct ids to be unique among all your routes.");
        }
        this.addRouteDefinition(routeDefinition);
        return routeDefinition.getId();
    }

    private void addTemplateBeans(RouteTemplateContext routeTemplateContext, RouteTemplateDefinition target) throws Exception {
        for (RouteTemplateBeanDefinition b : target.getTemplateBeans()) {
            HashMap props = new HashMap();
            if (b.getProperties() != null) {
                b.getProperties().forEach(p -> props.put(p.getKey(), p.getValue()));
            }
            if (b.getBeanSupplier() != null) {
                if (!props.isEmpty()) continue;
                if (b.getBeanClass() != null) {
                    routeTemplateContext.bind(b.getName(), b.getBeanClass(), b.getBeanSupplier());
                    continue;
                }
                routeTemplateContext.bind(b.getName(), b.getBeanSupplier());
                continue;
            }
            if (b.getScript() != null) {
                ScriptingLanguage slan;
                String script = b.getScript().getScript();
                Language lan = this.camelContext.resolveLanguage(b.getType());
                Class clazz = b.getBeanType() != null ? this.camelContext.getClassResolver().resolveMandatoryClass(b.getBeanType()) : (b.getBeanClass() != null ? b.getBeanClass() : Object.class);
                ScriptingLanguage scriptingLanguage = slan = lan instanceof ScriptingLanguage ? (ScriptingLanguage)((Object)lan) : null;
                if (slan != null) {
                    routeTemplateContext.bind(b.getName(), clazz, Suppliers.memorize(() -> {
                        HashMap<String, Object> bindings = new HashMap<String, Object>();
                        bindings.put("rtc", routeTemplateContext);
                        Object local = slan.evaluate(script, bindings, clazz);
                        if (!props.isEmpty()) {
                            DefaultModel.setPropertiesOnTarget(this.camelContext, local, props);
                        }
                        return local;
                    }));
                    continue;
                }
                routeTemplateContext.bind(b.getName(), clazz, Suppliers.memorize(() -> {
                    ExchangeFactory ef = this.camelContext.adapt(ExtendedCamelContext.class).getExchangeFactory();
                    Exchange dummy = ef.create(false);
                    try {
                        String text = ScriptHelper.resolveOptionalExternalScript(this.camelContext, dummy, script);
                        if (text != null) {
                            Expression exp = lan.createExpression(text);
                            Object local = exp.evaluate(dummy, clazz);
                            if (!props.isEmpty()) {
                                DefaultModel.setPropertiesOnTarget(this.camelContext, local, props);
                            }
                            Object t = local;
                            return t;
                        }
                        Object var8_9 = null;
                        return var8_9;
                    }
                    finally {
                        ef.release(dummy);
                    }
                }));
                continue;
            }
            if (b.getBeanClass() != null || b.getType() != null && b.getType().startsWith("#class:")) {
                Class<?> clazz;
                String className = null;
                String factoryMethod = null;
                String parameters = null;
                if (b.getType() != null) {
                    className = b.getType().substring(7);
                    if (className.endsWith(")") && className.indexOf(40) != -1) {
                        parameters = StringHelper.after(className, "(");
                        parameters = parameters.substring(0, parameters.length() - 1);
                        className = StringHelper.before(className, "(");
                    }
                    if (className != null && className.indexOf(35) != -1) {
                        factoryMethod = StringHelper.after(className, "#");
                        className = StringHelper.before(className, "#");
                    }
                }
                if (className != null && (factoryMethod != null || parameters != null)) {
                    clazz = this.camelContext.getClassResolver().resolveMandatoryClass(className);
                    String fqn = className;
                    String fm = factoryMethod;
                    String fp = parameters;
                    routeTemplateContext.bind(b.getName(), Object.class, Suppliers.memorize(() -> {
                        try {
                            Object local;
                            if (fm != null) {
                                local = fp != null ? PropertyBindingSupport.newInstanceFactoryParameters(this.camelContext, clazz, fm, fp) : this.camelContext.getInjector().newInstance(clazz, fm);
                                if (local == null) {
                                    throw new IllegalStateException("Cannot create bean instance using factory method: " + fqn + "#" + fm);
                                }
                            } else {
                                local = PropertyBindingSupport.newInstanceConstructorParameters(this.camelContext, clazz, fp);
                            }
                            if (!props.isEmpty()) {
                                DefaultModel.setPropertiesOnTarget(this.camelContext, local, props);
                            }
                            return local;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Cannot create bean: " + b.getType());
                        }
                    }));
                    continue;
                }
                clazz = b.getBeanClass() != null ? b.getBeanClass() : this.camelContext.getClassResolver().resolveMandatoryClass(className);
                routeTemplateContext.bind(b.getName(), clazz, Suppliers.memorize(() -> {
                    Object local = this.camelContext.getInjector().newInstance(clazz);
                    if (!props.isEmpty()) {
                        DefaultModel.setPropertiesOnTarget(this.camelContext, local, props);
                    }
                    return local;
                }));
                continue;
            }
            if (b.getType() != null && b.getType().startsWith("#type:")) {
                Class<?> clazz = this.camelContext.getClassResolver().resolveMandatoryClass(b.getType().substring(6));
                Set<?> found = this.getCamelContext().getRegistry().findByType(clazz);
                if (found == null || found.isEmpty()) {
                    throw new NoSuchBeanException(null, clazz.getName());
                }
                if (found.size() > 1) {
                    throw new NoSuchBeanException("Found " + found.size() + " beans of type: " + clazz + ". Only one bean expected.");
                }
                routeTemplateContext.bind(b.getName(), clazz, found.iterator().next());
                continue;
            }
            throw new IllegalArgumentException("Route template local bean: " + b.getName() + " has invalid type syntax: " + b.getType() + ". To refer to a class then prefix the value with #class such as: #class:fullyQualifiedClassName");
        }
    }

    @Override
    public synchronized List<RestDefinition> getRestDefinitions() {
        return this.restDefinitions;
    }

    @Override
    public synchronized void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        if (restDefinitions == null || restDefinitions.isEmpty()) {
            return;
        }
        this.restDefinitions.addAll(restDefinitions);
        if (addToRoutes) {
            for (RestDefinition restDefinition : restDefinitions) {
                List<RouteDefinition> routeDefinitions = restDefinition.asRouteDefinition(this.camelContext);
                this.addRouteDefinitions(routeDefinitions);
            }
        }
    }

    @Override
    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        if (serviceName == null) {
            serviceName = "";
        }
        return this.serviceCallConfigurations.get(serviceName);
    }

    @Override
    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put("", configuration);
    }

    @Override
    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (ServiceCallConfigurationDefinition configuration : configurations) {
                this.serviceCallConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put(serviceName, configuration);
    }

    @Override
    public HystrixConfigurationDefinition getHystrixConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.hystrixConfigurations.get(id);
    }

    @Override
    public void setHystrixConfiguration(HystrixConfigurationDefinition configuration) {
        this.hystrixConfigurations.put("", configuration);
    }

    @Override
    public void setHystrixConfigurations(List<HystrixConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (HystrixConfigurationDefinition configuration : configurations) {
                this.hystrixConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addHystrixConfiguration(String id, HystrixConfigurationDefinition configuration) {
        this.hystrixConfigurations.put(id, configuration);
    }

    @Override
    public Resilience4jConfigurationDefinition getResilience4jConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.resilience4jConfigurations.get(id);
    }

    @Override
    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put("", configuration);
    }

    @Override
    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (Resilience4jConfigurationDefinition configuration : configurations) {
                this.resilience4jConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addResilience4jConfiguration(String id, Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put(id, configuration);
    }

    @Override
    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.faultToleranceConfigurations.get(id);
    }

    @Override
    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put("", configuration);
    }

    @Override
    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (FaultToleranceConfigurationDefinition configuration : configurations) {
                this.faultToleranceConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addFaultToleranceConfiguration(String id, FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put(id, configuration);
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        DataFormatDefinition type = DefaultModel.lookup(this.camelContext, name, DataFormatDefinition.class);
        if (type == null && this.getDataFormats() != null) {
            type = this.getDataFormats().get(name);
        }
        return type;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition(String id) {
        for (RouteDefinition route : this.getRouteDefinitions()) {
            Collection<ProcessorDefinition> col = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
            for (ProcessorDefinition proc : col) {
                if (!id.equals(proc.getId())) continue;
                return proc;
            }
        }
        return null;
    }

    @Override
    public <T extends ProcessorDefinition<T>> T getProcessorDefinition(String id, Class<T> type) {
        ProcessorDefinition<?> answer = this.getProcessorDefinition(id);
        if (answer != null) {
            return (T)((ProcessorDefinition)type.cast(answer));
        }
        return null;
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public List<TransformerDefinition> getTransformers() {
        return this.transformers;
    }

    @Override
    public void setTransformers(List<TransformerDefinition> transformers) {
        this.transformers = transformers;
    }

    @Override
    public List<ValidatorDefinition> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(List<ValidatorDefinition> validators) {
        this.validators = validators;
    }

    @Override
    public void setRouteFilterPattern(String include, String exclude) {
        this.setRouteFilter(RouteFilters.filterByPattern(include, exclude));
    }

    @Override
    public Function<RouteDefinition, Boolean> getRouteFilter() {
        return this.routeFilter;
    }

    @Override
    public void setRouteFilter(Function<RouteDefinition, Boolean> routeFilter) {
        this.routeFilter = routeFilter;
    }

    @Override
    public ModelReifierFactory getModelReifierFactory() {
        return this.modelReifierFactory;
    }

    @Override
    public void setModelReifierFactory(ModelReifierFactory modelReifierFactory) {
        this.modelReifierFactory = modelReifierFactory;
    }

    protected boolean shouldStartRoutes() {
        return this.camelContext.isStarted() && !this.camelContext.isStarting();
    }

    private static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties) {
        ObjectHelper.notNull(context, "context");
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        if (target instanceof CamelContext) {
            throw new UnsupportedOperationException("Configuring the Camel Context is not supported");
        }
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService(target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            configurer = context.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(target.getClass().getSimpleName(), context);
        }
        try {
            PropertyBindingSupport.build().withMandatory(true).withRemoveParameters(false).withConfigurer(configurer).withIgnoreCase(true).withFlattenProperties(true).bind(context, target, properties);
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                String prefix = e.getOptionPrefix();
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                key = prefix != null ? prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), null, key, e.getCause());
        }
    }
}

